/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.trifles.items;

import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Slime;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;
import org.oddlama.vane.annotation.item.VaneItem;
import org.oddlama.vane.core.item.CustomItem;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.trifles.Trifles;
import org.oddlama.vane.util.PlayerUtil;

@VaneItem(name="slime_bucket", base=Material.SLIME_BALL, model_data=7733268, version=1)
public class SlimeBucket
extends CustomItem<Trifles> {
    private static final float CUSTOM_MODEL_DATA_QUIET = 7733268.0f;
    private static final float CUSTOM_MODEL_DATA_JUMPY = 7733269.0f;
    private HashSet<UUID> players_in_slime_chunks = new HashSet();

    public SlimeBucket(Context<Trifles> context) {
        super(context);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void on_player_interact_entity(PlayerInteractEntityEvent event) {
        Slime slime;
        Entity entity = event.getRightClicked();
        if (!(entity instanceof Slime) || (slime = (Slime)entity).getSize() != 1) {
            return;
        }
        if (entity.isDead()) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item_in_hand = player.getEquipment().getItem(event.getHand());
        if (item_in_hand.getType() != Material.BUCKET) {
            return;
        }
        entity.remove();
        PlayerUtil.swing_arm((Player)player, (EquipmentSlot)event.getHand());
        player.playSound((Entity)player, Sound.ENTITY_SLIME_JUMP, SoundCategory.MASTER, 1.0f, 2.0f);
        ItemStack new_stack = this.newStack();
        new_stack.editMeta(meta -> {
            float correct_model_data = player.getChunk().isSlimeChunk() ? 7733269.0f : 7733268.0f;
            CustomModelDataComponent customModelDataComponent = meta.getCustomModelDataComponent();
            customModelDataComponent.setFloats(List.of(Float.valueOf(correct_model_data)));
            meta.setCustomModelDataComponent(customModelDataComponent);
        });
        if (item_in_hand.getAmount() == 1) {
            player.getEquipment().setItem(event.getHand(), new_stack);
        } else {
            item_in_hand.setAmount(item_in_hand.getAmount() - 1);
            PlayerUtil.give_items((Player)player, (ItemStack)new_stack, (int)1);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void on_player_interact(PlayerInteractEvent event) {
        SlimeBucket slime_bucket;
        if (!event.hasBlock() || event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item_in_hand = player.getEquipment().getItem(event.getHand());
        org.oddlama.vane.core.item.api.CustomItem custom_item = ((Trifles)this.get_module()).core.item_registry().get(item_in_hand);
        if (!(custom_item instanceof SlimeBucket) || !(slime_bucket = (SlimeBucket)custom_item).enabled()) {
            return;
        }
        event.setUseInteractedBlock(Event.Result.DENY);
        event.setUseItemInHand(Event.Result.DENY);
        Location loc = event.getInteractionPoint();
        loc.getWorld().spawnEntity(loc, EntityType.SLIME, CreatureSpawnEvent.SpawnReason.CUSTOM, entity -> {
            if (entity instanceof Slime) {
                Slime slime = (Slime)entity;
                slime.setSize(1);
            }
        });
        player.playSound((Entity)player, Sound.ENTITY_SLIME_JUMP, SoundCategory.MASTER, 1.0f, 2.0f);
        PlayerUtil.swing_arm((Player)player, (EquipmentSlot)event.getHand());
        if (item_in_hand.getAmount() == 1) {
            player.getEquipment().setItem(event.getHand(), new ItemStack(Material.BUCKET));
        } else {
            item_in_hand.setAmount(item_in_hand.getAmount() - 1);
            PlayerUtil.give_items((Player)player, (ItemStack)new ItemStack(Material.BUCKET), (int)1);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void on_player_move(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        boolean in_slime_chunk = event.getTo().getChunk().isSlimeChunk();
        boolean in_set = this.players_in_slime_chunks.contains(player.getUniqueId());
        if (in_set != in_slime_chunk) {
            if (in_slime_chunk) {
                this.players_in_slime_chunks.add(player.getUniqueId());
            } else {
                this.players_in_slime_chunks.remove(player.getUniqueId());
            }
            float correct_model_data = in_slime_chunk ? 7733269.0f : 7733268.0f;
            for (ItemStack item : player.getInventory().getContents()) {
                SlimeBucket slime_bucket;
                org.oddlama.vane.core.item.api.CustomItem custom_item = ((Trifles)this.get_module()).core.item_registry().get(item);
                if (!(custom_item instanceof SlimeBucket) || !(slime_bucket = (SlimeBucket)custom_item).enabled()) continue;
                item.editMeta(meta -> {
                    CustomModelDataComponent customModelDataComponent = meta.getCustomModelDataComponent();
                    customModelDataComponent.setFloats(List.of(Float.valueOf(correct_model_data)));
                    meta.setCustomModelDataComponent(customModelDataComponent);
                });
            }
        }
    }
}

