/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.trifles.items;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Random;
import net.kyori.adventure.text.Component;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.persistence.PersistentDataType;
import org.oddlama.vane.annotation.item.VaneItem;
import org.oddlama.vane.annotation.lang.LangMessageArray;
import org.oddlama.vane.core.config.recipes.RecipeDefinition;
import org.oddlama.vane.core.config.recipes.RecipeList;
import org.oddlama.vane.core.config.recipes.ShapedRecipeDefinition;
import org.oddlama.vane.core.item.CustomItem;
import org.oddlama.vane.core.item.api.InhibitBehavior;
import org.oddlama.vane.core.lang.TranslatedMessageArray;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.trifles.Trifles;
import org.oddlama.vane.util.ItemUtil;
import org.oddlama.vane.util.Nms;
import org.oddlama.vane.util.PlayerUtil;
import org.oddlama.vane.util.StorageUtil;

@VaneItem(name="trowel", base=Material.WARPED_FUNGUS_ON_A_STICK, durability=800, model_data=7733262, version=1)
public class Trowel
extends CustomItem<Trifles> {
    private static final NamespacedKey SENTINEL = StorageUtil.namespaced_key((String)"vane", (String)"trowel_lore");
    public static final NamespacedKey FEED_SOURCE = StorageUtil.namespaced_key((String)"vane", (String)"feed_source");
    private static Random random = new Random(23584982345L);
    @LangMessageArray
    public TranslatedMessageArray lang_lore;

    public Trowel(Context<Trifles> context) {
        super(context);
    }

    public RecipeList default_recipes() {
        return RecipeList.of((RecipeDefinition[])new RecipeDefinition[]{new ShapedRecipeDefinition("generic").shape(new String[]{"  s", "mm "}).set_ingredient('m', Material.IRON_INGOT).set_ingredient('s', Material.STICK).result(this.key().toString())});
    }

    private static boolean is_trowel_lore(Component component) {
        return ItemUtil.has_sentinel((Component)component, (NamespacedKey)SENTINEL);
    }

    private FeedSource feed_source(ItemStack item_stack) {
        if (!item_stack.hasItemMeta()) {
            return FeedSource.HOTBAR;
        }
        Integer ord = (Integer)item_stack.getItemMeta().getPersistentDataContainer().getOrDefault(FEED_SOURCE, PersistentDataType.INTEGER, (Object)0);
        if (ord < 0 || ord > FeedSource.values().length) {
            return FeedSource.HOTBAR;
        }
        return FeedSource.values()[ord];
    }

    private void feed_source(ItemStack item_stack, FeedSource feed_source) {
        item_stack.editMeta(meta -> meta.getPersistentDataContainer().set(FEED_SOURCE, PersistentDataType.INTEGER, (Object)feed_source.ordinal()));
    }

    private void update_lore(ItemStack item_stack) {
        ArrayList<Component> lore = item_stack.lore();
        if (lore == null) {
            lore = new ArrayList<Component>();
        }
        lore.removeIf(Trowel::is_trowel_lore);
        FeedSource feed_source = this.feed_source(item_stack);
        lore.addAll(this.lang_lore.format(new Object[]{"\u00a7a" + String.valueOf((Object)feed_source)}).stream().map(x -> ItemUtil.add_sentinel((Component)x, (NamespacedKey)SENTINEL)).toList());
        item_stack.lore(lore);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void on_player_click_inventory(InventoryClickEvent event) {
        Trowel trowel;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof org.bukkit.entity.Player)) {
            return;
        }
        org.bukkit.entity.Player player = (org.bukkit.entity.Player)humanEntity;
        if (event.getAction() != InventoryAction.PICKUP_HALF || event.getCursor() != null && event.getCursor().getType() != Material.AIR) {
            return;
        }
        ItemStack item = event.getCurrentItem();
        org.oddlama.vane.core.item.api.CustomItem custom_item = ((Trifles)this.get_module()).core.item_registry().get(item);
        if (!(custom_item instanceof Trowel) || !(trowel = (Trowel)custom_item).enabled()) {
            return;
        }
        FeedSource feed_source = this.feed_source(item);
        this.feed_source(item, feed_source.next());
        this.update_lore(item);
        player.playSound((Entity)player, Sound.UI_BUTTON_CLICK, SoundCategory.MASTER, 1.0f, 5.0f);
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void on_player_interact_block(PlayerInteractEvent event) {
        Trowel trowel;
        if (!event.hasBlock() || event.getAction() != Action.RIGHT_CLICK_BLOCK || event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        org.bukkit.entity.Player player = event.getPlayer();
        ItemStack item_in_hand = player.getEquipment().getItem(EquipmentSlot.HAND);
        org.oddlama.vane.core.item.api.CustomItem custom_item = ((Trifles)this.get_module()).core.item_registry().get(item_in_hand);
        if (!(custom_item instanceof Trowel) || !(trowel = (Trowel)custom_item).enabled()) {
            return;
        }
        event.setUseInteractedBlock(Event.Result.DENY);
        event.setUseItemInHand(Event.Result.DENY);
        Block block = event.getClickedBlock();
        PlayerInventory inventory = player.getInventory();
        FeedSource feed_source = this.feed_source(item_in_hand);
        int[] possible_slots = (int[])feed_source.slots().clone();
        int count = possible_slots.length;
        while (count > 0) {
            int index = random.nextInt(count);
            ItemStack item_stack = inventory.getItem(possible_slots[index]);
            if (item_stack == null || !item_stack.getType().isBlock() || Tag.SHULKER_BOXES.isTagged((Keyed)item_stack.getType())) {
                possible_slots[index] = possible_slots[--count];
                continue;
            }
            org.oddlama.vane.core.item.api.CustomItem custom_item_slot = ((Trifles)this.get_module()).core.item_registry().get(item_stack);
            if (custom_item_slot != null) {
                possible_slots[index] = possible_slots[--count];
                continue;
            }
            net.minecraft.world.item.ItemStack nms_item = Nms.item_handle((ItemStack)item_stack);
            ServerPlayer nms_player = Nms.player_handle((org.bukkit.entity.Player)player);
            ServerLevel nms_world = Nms.world_handle((World)player.getWorld());
            Direction direction = CraftBlock.blockFaceToNotch((BlockFace)event.getBlockFace());
            BlockPos block_pos = new BlockPos(block.getX(), block.getY(), block.getZ());
            Location interaction_point = event.getInteractionPoint();
            Vec3 hit_pos = new Vec3(interaction_point.getX(), interaction_point.getY(), interaction_point.getZ());
            BlockHitResult block_hit_result = new BlockHitResult(hit_pos, direction, block_pos, false);
            int amount_pre = nms_item.getCount();
            UseOnContext action_context = new UseOnContext((Level)nms_world, (Player)nms_player, InteractionHand.MAIN_HAND, nms_item, block_hit_result);
            SoundType sound_type = null;
            Item item = nms_item.getItem();
            if (item instanceof BlockItem) {
                BlockItem block_item = (BlockItem)item;
                BlockState place_state = block_item.getBlock().getStateForPlacement(new BlockPlaceContext(action_context));
                sound_type = place_state.getSoundType();
            }
            InteractionResult result = nms_item.useOn(action_context);
            if (player.getGameMode() == GameMode.CREATIVE) {
                nms_item.setCount(amount_pre);
            }
            if (result.consumesAction()) {
                PlayerUtil.swing_arm((org.bukkit.entity.Player)player, (EquipmentSlot)EquipmentSlot.HAND);
                ItemUtil.damage_item((org.bukkit.entity.Player)player, (ItemStack)item_in_hand, (int)1);
                if (sound_type != null) {
                    nms_world.playSound(null, block_pos, sound_type.getPlaceSound(), SoundSource.BLOCKS, (sound_type.getVolume() + 1.0f) / 2.0f, sound_type.getPitch() * 0.8f);
                }
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(nms_player, block_pos, nms_item);
            }
            nms_player.connection.send((Packet)new ClientboundBlockUpdatePacket((BlockGetter)nms_world, block_pos));
            nms_player.connection.send((Packet)new ClientboundBlockUpdatePacket((BlockGetter)nms_world, block_pos.relative(direction)));
            return;
        }
        player.playSound((Entity)player, Sound.UI_STONECUTTER_SELECT_RECIPE, SoundCategory.MASTER, 1.0f, 2.0f);
    }

    public ItemStack updateItemStack(ItemStack item_stack) {
        this.update_lore(item_stack);
        return item_stack;
    }

    public EnumSet<InhibitBehavior> inhibitedBehaviors() {
        return EnumSet.of(InhibitBehavior.USE_IN_VANILLA_RECIPE, InhibitBehavior.USE_OFFHAND);
    }

    public static enum FeedSource {
        HOTBAR("Hotbar", new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8}),
        FIRST_ROW("First Inventory Row", new int[]{9, 10, 11, 12, 13, 14, 15, 16, 17}),
        SECOND_ROW("Second Inventory Row", new int[]{18, 19, 20, 21, 22, 23, 24, 25, 26}),
        THIRD_ROW("Third Inventory Row", new int[]{27, 28, 29, 30, 31, 32, 33, 34, 35});

        private String display_name;
        private int[] slots;

        private FeedSource(String display_name, int[] slots) {
            this.display_name = display_name;
            this.slots = slots;
        }

        public String display_name() {
            return this.display_name;
        }

        public FeedSource next() {
            return FeedSource.values()[(this.ordinal() + 1) % FeedSource.values().length];
        }

        public int[] slots() {
            return this.slots;
        }
    }
}

