/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.trifles.items;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.oddlama.vane.annotation.config.ConfigInt;
import org.oddlama.vane.annotation.item.VaneItem;
import org.oddlama.vane.core.Listener;
import org.oddlama.vane.core.item.CustomItem;
import org.oddlama.vane.core.item.CustomItemHelper;
import org.oddlama.vane.core.item.api.InhibitBehavior;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.trifles.Trifles;
import org.oddlama.vane.util.Conversions;
import org.oddlama.vane.util.PlayerUtil;

public class XpBottles
extends Listener<Trifles> {
    public List<XpBottle> bottles = new ArrayList<XpBottle>();

    public XpBottles(Context<Trifles> context) {
        super((Context)context.group("xp_bottles", "Several xp bottles storing a certain amount of experience."));
        this.bottles.add(new SmallXpBottle((Context<Trifles>)this.get_context()));
        this.bottles.add(new MediumXpBottle((Context<Trifles>)this.get_context()));
        this.bottles.add(new LargeXpBottle((Context<Trifles>)this.get_context()));
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void on_player_item_consume(PlayerItemConsumeEvent event) {
        Player player;
        XpBottle bottle;
        ItemStack item = event.getItem();
        org.oddlama.vane.core.item.api.CustomItem custom_item = ((Trifles)this.get_module()).core.item_registry().get(item);
        if (!(custom_item instanceof XpBottle) || !(bottle = (XpBottle)custom_item).enabled()) {
            return;
        }
        boolean main_hand = item.equals((Object)(player = event.getPlayer()).getInventory().getItemInMainHand());
        PlayerUtil.remove_one_item_from_hand((Player)player, (EquipmentSlot)(main_hand ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND));
        PlayerUtil.give_item((Player)player, (ItemStack)CustomItemHelper.newStack((String)"vane_trifles:empty_xp_bottle"));
        ((Trifles)this.get_module()).last_xp_bottle_consume_time.put(player.getUniqueId(), System.currentTimeMillis());
        player.giveExp(Conversions.exp_for_level((int)bottle.config_capacity), false);
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, SoundCategory.PLAYERS, 1.0f, 1.0f);
        event.setCancelled(true);
    }

    @VaneItem(name="small_xp_bottle", base=Material.HONEY_BOTTLE, model_data=7733259, version=1)
    public static class SmallXpBottle
    extends XpBottle {
        public SmallXpBottle(Context<Trifles> context) {
            super(context);
        }

        public int config_capacity_def() {
            return 10;
        }
    }

    @VaneItem(name="medium_xp_bottle", base=Material.HONEY_BOTTLE, model_data=7733260, version=1)
    public static class MediumXpBottle
    extends XpBottle {
        public MediumXpBottle(Context<Trifles> context) {
            super(context);
        }

        public int config_capacity_def() {
            return 20;
        }
    }

    @VaneItem(name="large_xp_bottle", base=Material.HONEY_BOTTLE, model_data=7733261, version=1)
    public static class LargeXpBottle
    extends XpBottle {
        public LargeXpBottle(Context<Trifles> context) {
            super(context);
        }

        public int config_capacity_def() {
            return 30;
        }
    }

    public static abstract class XpBottle
    extends CustomItem<Trifles> {
        @ConfigInt(def=-1, desc="Level capacity.")
        public int config_capacity;

        public XpBottle(Context<Trifles> context) {
            super(context);
        }

        public Component displayName() {
            return super.displayName().color((TextColor)NamedTextColor.YELLOW);
        }

        public EnumSet<InhibitBehavior> inhibitedBehaviors() {
            return EnumSet.of(InhibitBehavior.USE_IN_VANILLA_RECIPE, InhibitBehavior.USE_OFFHAND);
        }
    }
}

