/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.trifles.items.storage;

import java.util.EnumSet;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.oddlama.vane.annotation.item.VaneItem;
import org.oddlama.vane.core.config.recipes.RecipeDefinition;
import org.oddlama.vane.core.config.recipes.RecipeList;
import org.oddlama.vane.core.config.recipes.ShapedRecipeDefinition;
import org.oddlama.vane.core.item.CustomItem;
import org.oddlama.vane.core.item.api.InhibitBehavior;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.trifles.StorageGroup;
import org.oddlama.vane.trifles.Trifles;
import org.oddlama.vane.util.PlayerUtil;

@VaneItem(name="pouch", base=Material.DROPPER, model_data=7733270, version=1)
public class Pouch
extends CustomItem<Trifles> {
    public Pouch(Context<Trifles> context) {
        super(context);
    }

    public RecipeList default_recipes() {
        return RecipeList.of((RecipeDefinition[])new RecipeDefinition[]{new ShapedRecipeDefinition("generic").shape(new String[]{"sls", "l l", "lll"}).set_ingredient('s', Material.STRING).set_ingredient('l', Material.RABBIT_HIDE).result(this.key().toString())});
    }

    public ItemStack updateItemStack(ItemStack item_stack) {
        item_stack.editMeta(meta -> meta.getPersistentDataContainer().set(StorageGroup.STORAGE_IS_OPEN, PersistentDataType.BOOLEAN, (Object)false));
        return item_stack;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=false)
    public void on_player_right_click(PlayerInteractEvent event) {
        Pouch pouch;
        if (!event.hasItem() || event.useItemInHand() == Event.Result.DENY) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK && event.getAction() != Action.RIGHT_CLICK_AIR) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = player.getEquipment().getItem(event.getHand());
        org.oddlama.vane.core.item.api.CustomItem custom_item = ((Trifles)this.get_module()).core.item_registry().get(item);
        if (!(custom_item instanceof Pouch) || !(pouch = (Pouch)custom_item).enabled()) {
            return;
        }
        for (ItemStack inv_item : player.getInventory().getContents()) {
            if (inv_item == null || !inv_item.hasItemMeta()) continue;
            inv_item.editMeta(meta -> {
                if (meta.getPersistentDataContainer().has(StorageGroup.STORAGE_IS_OPEN)) {
                    meta.getPersistentDataContainer().set(StorageGroup.STORAGE_IS_OPEN, PersistentDataType.BOOLEAN, (Object)false);
                }
            });
        }
        item.editMeta(meta -> meta.getPersistentDataContainer().set(StorageGroup.STORAGE_IS_OPEN, PersistentDataType.BOOLEAN, (Object)true));
        event.setUseInteractedBlock(Event.Result.DENY);
        event.setUseItemInHand(Event.Result.DENY);
        if (((Trifles)this.get_module()).storage_group.open_block_state_inventory(player, item)) {
            player.getWorld().playSound((Entity)player, Sound.ITEM_BUNDLE_DROP_CONTENTS, 1.0f, 1.2f);
            PlayerUtil.swing_arm((Player)player, (EquipmentSlot)event.getHand());
        }
    }

    public EnumSet<InhibitBehavior> inhibitedBehaviors() {
        return EnumSet.of(InhibitBehavior.USE_IN_VANILLA_RECIPE);
    }
}

