/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.proxycore;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.jetbrains.annotations.Nullable;
import org.oddlama.vane.proxycore.ProxyPlayer;
import org.oddlama.vane.proxycore.VaneProxyPlugin;
import org.oddlama.vane.proxycore.scheduler.ProxyScheduledTask;
import org.oddlama.vane.proxycore.util.TimeUtil;

public class Maintenance {
    public static final long[] NOTIFY_TIMES = new long[]{14400000L, 10800000L, 0x6DDD00L, 3600000L, 1800000L, 900000L, 600000L, 300000L, 240000L, 180000L, 120000L, 60000L, 30000L, 10000L, 5000L, 4000L, 3000L, 2000L, 1000L};
    public static long SHUTDOWN_THRESHOLD = 10000L;
    public static String MESSAGE_ABORTED = "\u00a77> \u00a7cServer maintenance \u00a7l\u00a76CANCELLED\u00a7r\u00a7c!";
    public static String MESSAGE_INFO = "\u00a77>\n\u00a77> \u00a7cScheduled maintenance in: \u00a76%time%\n\u00a77> \u00a7cExpected time remaining: \u00a76%remaining%\n\u00a77>";
    public static String MESSAGE_SCHEDULED = "\u00a77>\n\u00a77> \u00a7e\u21af\u00a7r \u00a76\u00a7lMaintenance active\u00a7r \u00a7e\u21af\u00a7r\n\u00a77>\n\u00a77> \u00a7cScheduled maintenance in: \u00a76%time%\n\u00a77> \u00a7cExpected duration: \u00a76%duration%\n\u00a77>";
    public static String MESSAGE_SHUTDOWN = "\u00a77> \u00a7cShutdown in \u00a76%time%\u00a7c!";
    public static String MESSAGE_KICK = "\u00a7e\u21af\u00a7r \u00a76\u00a7lMaintenance active\u00a7r \u00a7e\u21af\u00a7r\n\u00a7cExpected duration: \u00a76%duration%";
    public static String MOTD = "\u00a7e\u21af\u00a7r \u00a76\u00a7lMaintenance active\u00a7r \u00a7e\u21af\u00a7r\n\u00a7cExpected time remaining: \u00a76%remaining%";
    public static String MESSAGE_CONNECT = "%MOTD%\n\n\u00a77Please try again later.";
    private final VaneProxyPlugin plugin;
    private final File file = new File("./.maintenance");
    private final TaskEnable task_enable = new TaskEnable();
    private final TaskNotify task_notify = new TaskNotify();
    private boolean enabled = false;
    private long start = 0L;
    @Nullable
    private Long duration = 0L;

    public Maintenance(VaneProxyPlugin plugin) {
        this.plugin = plugin;
    }

    public long start() {
        return this.start;
    }

    @Nullable
    public Long duration() {
        return this.duration;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public void enable() {
        this.enabled = true;
        String kick_message = this.format_message(MESSAGE_KICK);
        for (ProxyPlayer player : this.plugin.get_proxy().getPlayers()) {
            player.disconnect(kick_message);
        }
        this.plugin.get_logger().log(Level.INFO, "Maintenance enabled!");
    }

    public void disable() {
        this.start = 0L;
        this.duration = 0L;
        this.enabled = false;
        this.task_enable.cancel();
        this.task_notify.cancel();
        this.file.delete();
    }

    public void abort() {
        if (this.start == 0L) {
            return;
        }
        if (this.start - System.currentTimeMillis() > 0L) {
            this.plugin.get_proxy().broadcast(MESSAGE_ABORTED);
        }
        this.disable();
        this.plugin.get_logger().log(Level.INFO, "Maintenance disabled!");
    }

    public void schedule(long start_millis, @Nullable Long duration_millis) {
        if (duration_millis == null && this.enabled) {
            this.plugin.get_logger().log(Level.WARNING, "Maintenance already enabled!");
            return;
        }
        this.enabled = false;
        this.start = start_millis;
        this.duration = duration_millis;
        this.save();
        this.task_enable.schedule();
        if (duration_millis != null) {
            this.task_notify.schedule();
        }
    }

    public void load() {
        if (this.file.exists()) {
            block20: {
                try (FileReader file_reader = new FileReader(this.file);
                     BufferedReader reader = new BufferedReader(file_reader);){
                    this.start = Long.parseLong(reader.readLine());
                    String duration_line = reader.readLine();
                    if (duration_line != null) {
                        this.duration = Long.parseLong(duration_line);
                        break block20;
                    }
                    this.duration = null;
                    this.enable();
                    return;
                }
                catch (IOException | NumberFormatException e) {
                    this.disable();
                    return;
                }
            }
            long delta = System.currentTimeMillis() - this.start;
            if (delta < 0L) {
                this.schedule(this.start, this.duration);
            } else if (delta - this.duration < 0L) {
                this.enable();
            } else {
                this.disable();
            }
        } else {
            this.disable();
        }
    }

    public void save() {
        try (FileWriter writer = new FileWriter(this.file);){
            if (this.duration != null) {
                writer.write(this.start + "\n" + this.duration);
            } else {
                writer.write(Long.toString(this.start));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String format_message(String message) {
        String remaining_string;
        String duration_string;
        String time;
        long timespan = this.start - System.currentTimeMillis();
        if (timespan <= 0L) {
            time = "Now";
        } else {
            if (timespan % 1000L >= 500L) {
                timespan += 1000L;
            }
            time = TimeUtil.format_time(timespan);
        }
        if (this.duration != null) {
            long remaining = this.duration + (this.start - System.currentTimeMillis());
            if (remaining > this.duration) {
                remaining = this.duration;
            } else if (remaining < 0L) {
                remaining = 0L;
            }
            duration_string = TimeUtil.format_time(this.duration);
            remaining_string = TimeUtil.format_time(remaining);
        } else {
            duration_string = "Indefinite";
            remaining_string = "Indefinite";
        }
        return message.replace("%MOTD%", MOTD).replace("%time%", time).replace("%duration%", duration_string).replace("%remaining%", remaining_string);
    }

    public class TaskEnable
    implements Runnable {
        private ProxyScheduledTask task = null;

        @Override
        public synchronized void run() {
            Maintenance.this.enable();
            this.task = null;
        }

        synchronized void cancel() {
            if (this.task != null) {
                this.task.cancel();
                this.task = null;
            }
        }

        synchronized void schedule() {
            this.cancel();
            long timespan = Maintenance.this.start() - System.currentTimeMillis();
            if (timespan < 0L) {
                timespan = 0L;
            }
            this.task = Maintenance.this.plugin.get_proxy().get_scheduler().schedule(Maintenance.this.plugin, this, timespan, TimeUnit.MILLISECONDS);
        }
    }

    public class TaskNotify
    implements Runnable {
        private ProxyScheduledTask task = null;
        private long notify_time = -1L;

        @Override
        public synchronized void run() {
            Maintenance.this.plugin.get_proxy().broadcast(Maintenance.this.format_message(this.notify_time <= SHUTDOWN_THRESHOLD ? MESSAGE_SHUTDOWN : MESSAGE_SCHEDULED));
            this.schedule();
        }

        public synchronized void cancel() {
            if (this.task != null) {
                this.task.cancel();
                this.task = null;
                this.notify_time = -1L;
            }
        }

        public synchronized void schedule() {
            this.cancel();
            long timespan = Maintenance.this.start - System.currentTimeMillis() - 500L;
            if (this.notify_time < 0L) {
                Maintenance.this.plugin.get_proxy().broadcast(Maintenance.this.format_message(MESSAGE_SCHEDULED));
                this.notify_time = timespan;
            }
            if ((this.notify_time = this.next_notify_time()) < 0L) {
                return;
            }
            this.task = Maintenance.this.plugin.get_proxy().get_scheduler().schedule(Maintenance.this.plugin, this, timespan - this.notify_time, TimeUnit.MILLISECONDS);
        }

        public long next_notify_time() {
            if (this.notify_time < 0L) {
                return -1L;
            }
            for (long t : NOTIFY_TIMES) {
                if (this.notify_time - t <= 0L) continue;
                return t;
            }
            return -1L;
        }
    }
}

