/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.proxycore;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.oddlama.vane.proxycore.Maintenance;
import org.oddlama.vane.proxycore.ProxyServer;
import org.oddlama.vane.proxycore.config.ConfigManager;
import org.oddlama.vane.proxycore.config.IVaneProxyServerInfo;
import org.oddlama.vane.proxycore.config.ManagedServer;
import org.oddlama.vane.proxycore.listeners.PreLoginEvent;
import org.oddlama.vane.proxycore.log.IVaneLogger;

public abstract class VaneProxyPlugin {
    public static final String CHANNEL_AUTH_MULTIPLEX_NAMESPACE = "vane_proxy";
    public static final String CHANNEL_AUTH_MULTIPLEX_NAME = "auth_multiplex";
    public static final String CHANNEL_AUTH_MULTIPLEX = "vane_proxy:auth_multiplex";
    public ConfigManager config = new ConfigManager(this);
    public Maintenance maintenance = new Maintenance(this);
    public IVaneLogger logger;
    public ProxyServer server;
    public File data_dir;
    private final LinkedHashMap<UUID, UUID> multiplexedUUIDs = new LinkedHashMap();
    private final LinkedHashMap<UUID, PreLoginEvent.MultiplexedPlayer> pending_multiplexer_logins = new LinkedHashMap();
    private boolean server_starting;

    public boolean is_online(IVaneProxyServerInfo server) {
        SocketAddress addr = server.getSocketAddress();
        if (!(addr instanceof InetSocketAddress)) {
            return false;
        }
        InetSocketAddress inet_addr = (InetSocketAddress)addr;
        boolean connected = false;
        try (Socket test = new Socket(inet_addr.getHostName(), inet_addr.getPort());){
            connected = test.isConnected();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return connected;
    }

    public String get_motd(IVaneProxyServerInfo server) {
        if (this.maintenance.enabled()) {
            return this.maintenance.format_message(Maintenance.MOTD);
        }
        ManagedServer cms = this.config.managed_servers.get(server.getName());
        if (cms == null) {
            return "";
        }
        ManagedServer.ConfigItemSource source = this.is_online(server) ? ManagedServer.ConfigItemSource.ONLINE : ManagedServer.ConfigItemSource.OFFLINE;
        return cms.motd(source);
    }

    @Nullable
    public String get_favicon(IVaneProxyServerInfo server) {
        ManagedServer cms = this.config.managed_servers.get(server.getName());
        if (cms == null) {
            return null;
        }
        ManagedServer.ConfigItemSource source = this.is_online(server) ? ManagedServer.ConfigItemSource.ONLINE : ManagedServer.ConfigItemSource.OFFLINE;
        return cms.favicon(source);
    }

    public File get_data_folder() {
        return this.data_dir;
    }

    public ProxyServer get_proxy() {
        return this.server;
    }

    @NotNull
    public IVaneLogger get_logger() {
        return this.logger;
    }

    @NotNull
    public Maintenance get_maintenance() {
        return this.maintenance;
    }

    @NotNull
    public ConfigManager get_config() {
        return this.config;
    }

    public void try_start_server(ManagedServer server) {
        if (this.server_starting) {
            return;
        }
        this.server.get_scheduler().runAsync(this, () -> {
            try {
                this.server_starting = true;
                this.get_logger().log(Level.INFO, "Running start command for server '" + server.id() + "': " + Arrays.toString(server.start_cmd()));
                Integer timeout = server.command_timeout();
                ProcessBuilder processBuilder = new ProcessBuilder(server.start_cmd());
                processBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
                processBuilder.redirectError(ProcessBuilder.Redirect.INHERIT);
                Process process = processBuilder.start();
                if (!process.waitFor(timeout.intValue(), TimeUnit.SECONDS)) {
                    this.get_logger().log(Level.SEVERE, "Server '" + server.id() + "'s start command timed out!");
                }
                if (process.exitValue() != 0) {
                    this.get_logger().log(Level.SEVERE, "Server '" + server.id() + "'s start command returned a nonzero exit code!");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.server_starting = false;
        });
    }

    public boolean can_join_maintenance(UUID uuid) {
        if (this.maintenance.enabled()) {
            return this.server.has_permission(uuid, "vane_proxy.bypass_maintenance");
        }
        return true;
    }

    public LinkedHashMap<UUID, UUID> get_multiplexed_uuids() {
        return this.multiplexedUUIDs;
    }

    public LinkedHashMap<UUID, PreLoginEvent.MultiplexedPlayer> get_pending_multiplexer_logins() {
        return this.pending_multiplexer_logins;
    }
}

