/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.proxycore.commands;

import org.oddlama.vane.proxycore.Maintenance;
import org.oddlama.vane.proxycore.ProxyPlayer;
import org.oddlama.vane.proxycore.VaneProxyPlugin;
import org.oddlama.vane.proxycore.commands.ProxyCommand;
import org.oddlama.vane.proxycore.commands.ProxyCommandSender;
import org.oddlama.vane.proxycore.util.TimeUtil;

public class ProxyMaintenanceCommand
extends ProxyCommand {
    public static String MESSAGE_INVALID_TIME_FORMAT = "\u00a7cInvalid time format \u00a76'%time%'\u00a7c!";

    public ProxyMaintenanceCommand(String permission, VaneProxyPlugin plugin) {
        super(permission, plugin);
    }

    @Override
    public void execute(ProxyCommandSender sender, String[] args) {
        ProxyPlayer player;
        if (sender instanceof ProxyPlayer && !this.has_permission((player = (ProxyPlayer)sender).get_unique_id())) {
            sender.send_message("No permission!");
            return;
        }
        Maintenance maintenance = this.plugin.get_maintenance();
        if (args.length == 1) {
            switch (args[0].toLowerCase()) {
                case "status": {
                    if (maintenance.start() != 0L) {
                        sender.send_message(maintenance.format_message(Maintenance.MESSAGE_INFO));
                    }
                    return;
                }
                case "on": {
                    maintenance.schedule(System.currentTimeMillis(), null);
                    return;
                }
                case "cancel": 
                case "off": {
                    maintenance.abort();
                    return;
                }
            }
        } else if (args.length == 3 && args[0].equalsIgnoreCase("schedule")) {
            long duration;
            long time;
            try {
                time = TimeUtil.parse_time(args[1]);
            }
            catch (NumberFormatException e) {
                sender.send_message(MESSAGE_INVALID_TIME_FORMAT.replace("%time%", args[1]));
                return;
            }
            try {
                duration = TimeUtil.parse_time(args[2]);
            }
            catch (NumberFormatException e) {
                sender.send_message(MESSAGE_INVALID_TIME_FORMAT.replace("%time%", args[2]));
                return;
            }
            maintenance.schedule(System.currentTimeMillis() + time, duration);
            return;
        }
        sender.send_message("\u00a77> \u00a73/maintenance \u00a73[ \u00a77cancel\u00a7r|\u00a77off \u00a73] \u00a7f- Cancel any scheduled/active maintenance\n\u00a77> \u00a73/maintenance \u00a73[ \u00a77status \u00a73] \u00a7f- Display info about scheduled/active maintenance\n\u00a77> \u00a73/maintenance \u00a73[ \u00a77on \u00a73] \u00a7f- Enable maintenance for an indefinite amount of time\n\u00a77> \u00a73/maintenance \u00a73[ \u00a77schedule \u00a73] \u00a77<\u00a7bin\u00a77> <\u00a7bduration\u00a77> \u00a7f- Schedule maintenance in <in> for <duration>\n\u00a77> \u00a73|\u00a77 time format\u00a77 \u00a7f- Examples: \u00a7b\u00a7o3h5m\u00a7r\u00a7f or \u00a7b\u00a7o1y2w3d4h5m6s\u00a7r");
    }
}

