/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.proxycore.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.oddlama.vane.proxycore.config.AuthMultiplex;
import org.oddlama.vane.proxycore.config.ManagedServer;

public class Config {
    public LinkedHashMap<Integer, AuthMultiplex> auth_multiplex;
    public LinkedHashMap<String, ManagedServer> managed_servers;

    public Config(File file) throws IOException {
        Object value;
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder((File)file).autosave().preserveInsertionOrder().sync().build();
        config.load();
        LinkedHashMap<Integer, AuthMultiplex> auth_multiplex = new LinkedHashMap<Integer, AuthMultiplex>();
        LinkedHashMap<String, ManagedServer> managed_servers = new LinkedHashMap<String, ManagedServer>();
        HashSet<Integer> registered_ports = new HashSet<Integer>();
        CommentedConfig multiplexers_config = (CommentedConfig)config.get("auth_multiplex");
        for (CommentedConfig.Entry multiplexer_conf : multiplexers_config.entrySet()) {
            int key;
            String key_string = multiplexer_conf.getKey();
            try {
                key = Integer.parseInt(key_string);
            }
            catch (Exception ignored) {
                throw new IllegalArgumentException("Multiplexer ID '" + key_string + "' is not an integer!");
            }
            value = multiplexer_conf.getValue();
            if (!(value instanceof CommentedConfig)) {
                throw new IllegalArgumentException("Multiplexer '" + key + "' has an invalid configuration!");
            }
            CommentedConfig multiplexer_config = (CommentedConfig)value;
            int port = multiplexer_config.getInt("port");
            if (registered_ports.contains(port)) {
                throw new IllegalArgumentException("Multiplexer ID '" + key_string + "' uses an already registered port!");
            }
            AuthMultiplex multiplexer = new AuthMultiplex(port, (List)multiplexer_config.get("allowed_uuids"));
            registered_ports.add(multiplexer.port);
            auth_multiplex.put(key, multiplexer);
        }
        this.auth_multiplex = auth_multiplex;
        CommentedConfig servers_config = (CommentedConfig)config.get("managed_servers");
        for (CommentedConfig.Entry server_conf : servers_config.entrySet()) {
            String key = server_conf.getKey();
            value = server_conf.getValue();
            if (!(value instanceof CommentedConfig)) {
                throw new IllegalArgumentException("Managed server '" + key + "' has an invalid configuration!");
            }
            CommentedConfig managed_server_config = (CommentedConfig)value;
            ManagedServer managed_server = new ManagedServer(key, (String)managed_server_config.get("display_name"), (CommentedConfig)managed_server_config.get("online"), (CommentedConfig)managed_server_config.get("offline"), (CommentedConfig)managed_server_config.get("start"));
            managed_servers.put(key, managed_server);
        }
        this.managed_servers = managed_servers;
    }
}

