/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.proxycore.config;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import org.jetbrains.annotations.Nullable;
import org.oddlama.vane.proxycore.VaneProxyPlugin;
import org.oddlama.vane.proxycore.config.AuthMultiplex;
import org.oddlama.vane.proxycore.config.Config;
import org.oddlama.vane.proxycore.config.ManagedServer;

public class ConfigManager {
    public final Map<String, ManagedServer> managed_servers = new HashMap<String, ManagedServer>();
    public final Map<Integer, AuthMultiplex> multiplexer_by_id = new HashMap<Integer, AuthMultiplex>();
    private final VaneProxyPlugin plugin;

    public ConfigManager(VaneProxyPlugin plugin) {
        this.plugin = plugin;
    }

    private File file() {
        return new File(this.plugin.get_data_folder(), "config.toml");
    }

    public boolean load() {
        Config parsed_config;
        File file = this.file();
        if (!file.exists() && !this.save_default(file)) {
            this.plugin.get_logger().log(Level.SEVERE, "Unable to create default config! Bailing.");
            return false;
        }
        try {
            parsed_config = new Config(file);
        }
        catch (Exception e) {
            this.plugin.get_logger().log(Level.SEVERE, "Error while loading config file '" + String.valueOf(file) + "'", e);
            return false;
        }
        if (parsed_config.auth_multiplex.containsKey(0)) {
            this.plugin.get_logger().log(Level.SEVERE, "Attempted to register a multiplexer with id 0!");
            return false;
        }
        HashSet<Integer> registered_ports = new HashSet<Integer>();
        for (AuthMultiplex multiplexer : parsed_config.auth_multiplex.values()) {
            registered_ports.add(multiplexer.port);
        }
        if (parsed_config.auth_multiplex.size() != registered_ports.size()) {
            this.plugin.get_logger().log(Level.SEVERE, "Attempted to register multiple multiplexers on the same port!");
            return false;
        }
        this.multiplexer_by_id.putAll(parsed_config.auth_multiplex);
        this.managed_servers.putAll(parsed_config.managed_servers);
        return true;
    }

    public boolean save_default(File file) {
        try {
            file.getParentFile().mkdirs();
            Files.copy(Objects.requireNonNull(this.getClass().getClassLoader().getResourceAsStream("config.toml")), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return true;
        }
        catch (Exception e) {
            this.plugin.get_logger().log(Level.SEVERE, "Error while writing config file '" + String.valueOf(file) + "'", e);
            return false;
        }
    }

    @Nullable
    public Map.Entry<Integer, AuthMultiplex> get_multiplexer_for_port(Integer port) {
        for (Map.Entry<Integer, AuthMultiplex> multiplexer : this.multiplexer_by_id.entrySet()) {
            if (!Objects.equals(multiplexer.getValue().port, port)) continue;
            return multiplexer;
        }
        return null;
    }
}

