/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.proxycore.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Base64;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManagedServer {
    public String display_name;
    public ServerStart start;
    private final String id;
    private final StatefulConfiguration online_config;
    private final StatefulConfiguration offline_config;

    public ManagedServer(String id, String display_name, CommentedConfig online_config_section, CommentedConfig offline_config_section, CommentedConfig start) throws IOException {
        this.id = id;
        this.display_name = display_name;
        this.online_config = new StatefulConfiguration(id, display_name, online_config_section);
        this.offline_config = new StatefulConfiguration(id, display_name, offline_config_section);
        this.start = new ServerStart(id, display_name, start);
    }

    @NotNull
    public String id() {
        return this.id;
    }

    @Nullable
    public String favicon(ConfigItemSource source) {
        switch (source) {
            case ONLINE: {
                return this.online_config.encoded_favicon;
            }
            case OFFLINE: {
                return this.offline_config.encoded_favicon;
            }
        }
        return null;
    }

    public String[] start_cmd() {
        return this.start.cmd;
    }

    public String start_kick_msg() {
        return this.start.kick_msg;
    }

    private String random_quote(ConfigItemSource source) {
        String[] quote_set;
        switch (source) {
            case ONLINE: {
                quote_set = this.online_config.quotes;
                break;
            }
            case OFFLINE: {
                quote_set = this.offline_config.quotes;
                break;
            }
            default: {
                return "";
            }
        }
        if (quote_set == null || quote_set.length == 0) {
            return "";
        }
        return quote_set[new Random().nextInt(quote_set.length)];
    }

    public String motd(ConfigItemSource source) {
        ConfigItemSource quote_source;
        String sourced_motd;
        switch (source) {
            case ONLINE: {
                sourced_motd = this.online_config.motd;
                quote_source = ConfigItemSource.ONLINE;
                break;
            }
            case OFFLINE: {
                sourced_motd = this.offline_config.motd;
                quote_source = ConfigItemSource.OFFLINE;
                break;
            }
            default: {
                return "";
            }
        }
        if (sourced_motd == null) {
            return "";
        }
        return sourced_motd.replace("{QUOTE}", this.random_quote(quote_source));
    }

    public Integer command_timeout() {
        return this.start.timeout;
    }

    private static class StatefulConfiguration {
        public String[] quotes = null;
        public String motd = null;
        @Nullable
        private String encoded_favicon;

        public StatefulConfiguration(String id, String display_name, CommentedConfig config) throws IOException {
            Object favicon_path;
            Object motd;
            if (config == null) {
                return;
            }
            List quotes = (List)config.get("quotes");
            if (quotes != null) {
                this.quotes = (String[])quotes.stream().filter(s -> !s.isBlank()).map(s -> s.replace("{SERVER}", id).replace("{SERVER_DISPLAY_NAME}", display_name)).toArray(String[]::new);
            }
            if ((motd = config.get("motd")) != null && !(motd instanceof String)) {
                throw new IllegalArgumentException("Managed server '" + id + "' has a non-string MOTD!");
            }
            if (motd != null && !((String)motd).isEmpty()) {
                this.motd = ((String)motd).replace("{SERVER_DISPLAY_NAME}", display_name);
            }
            if ((favicon_path = config.get("favicon")) != null && !(favicon_path instanceof String)) {
                throw new IllegalArgumentException("Managed server '" + id + "' has a non-string favicon path!");
            }
            if (favicon_path != null && !((String)favicon_path).isEmpty()) {
                this.encoded_favicon = StatefulConfiguration.encode_favicon(id, (String)favicon_path);
            }
        }

        private static String encode_favicon(String id, String favicon_path) throws IOException {
            BufferedImage image;
            File favicon_file = new File(favicon_path.replace("{SERVER}", id));
            try {
                image = ImageIO.read(favicon_file);
            }
            catch (IOException e) {
                throw new IOException("Failed to read favicon file: " + e.getMessage());
            }
            if (image.getWidth() != 64 || image.getHeight() != 64) {
                throw new IllegalArgumentException("Favicon has invalid dimensions (must be 64x64)");
            }
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "PNG", stream);
            byte[] favicon_bytes = stream.toByteArray();
            String encoded_favicon = "data:image/png;base64," + Base64.getEncoder().encodeToString(favicon_bytes);
            if (encoded_favicon.length() > Short.MAX_VALUE) {
                throw new IllegalArgumentException("Favicon file too large for server to process");
            }
            return encoded_favicon;
        }
    }

    public static class ServerStart {
        private static final int DEFAULT_TIMEOUT_SECONDS = 10;
        public String[] cmd;
        public Integer timeout;
        public String kick_msg;
        public boolean allow_anyone;

        public ServerStart(String id, String display_name, CommentedConfig config) {
            List cmd = (List)config.get("cmd");
            Object timeout = config.get("timeout");
            Object kick_msg = config.get("kick_msg");
            Object allow_anyone = config.get("allow_anyone");
            this.cmd = cmd != null ? (String[])cmd.stream().map(s -> s.replace("{SERVER}", id)).toArray(String[]::new) : null;
            if (kick_msg != null && !(kick_msg instanceof String)) {
                throw new IllegalArgumentException("Managed server '" + id + "' has an invalid kick message!");
            }
            this.kick_msg = kick_msg != null ? ((String)kick_msg).replace("{SERVER}", id).replace("{SERVER_DISPLAY_NAME}", display_name) : null;
            this.allow_anyone = allow_anyone != null ? (Boolean)allow_anyone : false;
            if (timeout == null) {
                this.timeout = 10;
                return;
            }
            if (!(timeout instanceof Integer)) {
                throw new IllegalArgumentException("Managed server '" + id + "' has an invalid command timeout!");
            }
            this.timeout = (Integer)timeout;
        }
    }

    public static enum ConfigItemSource {
        ONLINE,
        OFFLINE;

    }
}

