/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.proxycore.listeners;

import java.util.UUID;
import java.util.logging.Level;
import org.oddlama.vane.proxycore.Maintenance;
import org.oddlama.vane.proxycore.ProxyPendingConnection;
import org.oddlama.vane.proxycore.VaneProxyPlugin;
import org.oddlama.vane.proxycore.config.IVaneProxyServerInfo;
import org.oddlama.vane.proxycore.config.ManagedServer;
import org.oddlama.vane.proxycore.listeners.ProxyCancellableEvent;
import org.oddlama.vane.proxycore.listeners.ProxyEvent;

public abstract class LoginEvent
implements ProxyEvent,
ProxyCancellableEvent {
    VaneProxyPlugin plugin;
    IVaneProxyServerInfo server_info;
    ProxyPendingConnection connection;

    public LoginEvent(VaneProxyPlugin plugin, IVaneProxyServerInfo server_info, ProxyPendingConnection connection) {
        this.plugin = plugin;
        this.server_info = server_info;
        this.connection = connection;
    }

    @Override
    public final void fire() {
        UUID connection_uuid = this.connection.get_unique_id();
        assert (connection_uuid != null);
        UUID uuid = this.plugin.get_multiplexed_uuids().getOrDefault(connection_uuid, connection_uuid);
        if (!this.plugin.can_join_maintenance(uuid)) {
            this.cancel(this.plugin.get_maintenance().format_message(Maintenance.MESSAGE_CONNECT));
            return;
        }
        this.plugin.get_logger().log(Level.INFO, "Connection '" + this.connection.get_name() + "' is connecting to '" + this.server_info.getName() + "'");
        if (!this.plugin.is_online(this.server_info)) {
            ManagedServer cms = this.plugin.get_config().managed_servers.get(this.server_info.getName());
            if (!cms.start.allow_anyone && !this.connection.can_start_server(this.plugin.get_proxy(), this.server_info.getName())) {
                this.plugin.get_logger().log(Level.INFO, "Disconnecting '" + this.connection.get_name() + "' because they don't have the permission to start server '" + this.server_info.getName() + "'");
                this.cancel("Server is offline and you don't have the permission to start it");
                return;
            }
            if (cms == null || cms.start_cmd() == null) {
                this.plugin.get_logger().log(Level.SEVERE, "Could not start server '" + this.server_info.getName() + "', no start command was set!");
                this.cancel("Could not start server");
            } else {
                this.plugin.try_start_server(cms);
                if (cms.start_kick_msg() == null) {
                    this.cancel("Server is starting");
                } else {
                    this.cancel(cms.start_kick_msg());
                }
            }
        }
    }
}

