/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.proxycore.listeners;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.oddlama.vane.proxycore.Maintenance;
import org.oddlama.vane.proxycore.ProxyPendingConnection;
import org.oddlama.vane.proxycore.Util;
import org.oddlama.vane.proxycore.VaneProxyPlugin;
import org.oddlama.vane.proxycore.config.AuthMultiplex;
import org.oddlama.vane.proxycore.config.IVaneProxyServerInfo;
import org.oddlama.vane.proxycore.listeners.ProxyCancellableEvent;
import org.oddlama.vane.proxycore.listeners.ProxyEvent;
import org.oddlama.vane.proxycore.util.Resolve;

public abstract class PreLoginEvent
implements ProxyEvent,
ProxyCancellableEvent {
    public static String MESSAGE_MULTIPLEX_MOJANG_AUTH_NO_PERMISSION_KICK = "\u00a7cYou have no permission to use this auth multiplexer!";
    public VaneProxyPlugin plugin;

    public PreLoginEvent(VaneProxyPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void fire() {
        assert (false);
    }

    public void fire(PreLoginDestination destination) {
        UUID uuid;
        ProxyPendingConnection connection = this.get_connection();
        int port = connection.get_port();
        Map.Entry<Integer, AuthMultiplex> multiplexer = this.plugin.get_config().get_multiplexer_for_port(port);
        if (multiplexer == null) {
            return;
        }
        Integer multiplexer_id = multiplexer.getKey();
        String playerName = connection.get_name();
        try {
            uuid = Resolve.resolve_uuid(playerName);
        }
        catch (IOException | URISyntaxException e) {
            this.plugin.get_logger().log(Level.WARNING, "Failed to resolve UUID for player '" + playerName + "'", e);
            return;
        }
        if (!this.plugin.can_join_maintenance(uuid)) {
            this.cancel(this.plugin.get_maintenance().format_message(Maintenance.MESSAGE_CONNECT));
            return;
        }
        if (!multiplexer.getValue().uuid_is_allowed(uuid)) {
            this.cancel(MESSAGE_MULTIPLEX_MOJANG_AUTH_NO_PERMISSION_KICK);
            return;
        }
        String name = connection.get_name();
        UUID new_uuid = Util.add_uuid(uuid, multiplexer_id.intValue());
        String new_uuid_str = new_uuid.toString();
        String new_name = new_uuid_str.substring(new_uuid_str.length() - 16).replace("-", "_");
        this.plugin.get_logger().log(Level.INFO, "auth multiplex request from player " + name + " connecting from " + connection.get_socket_address().toString());
        MultiplexedPlayer multiplexed_player = new MultiplexedPlayer(multiplexer_id, name, new_name, uuid, new_uuid);
        if (!this.implementation_specific_auth(multiplexed_player)) {
            return;
        }
        switch (destination) {
            case MULTIPLEXED_UUIDS: {
                this.plugin.get_multiplexed_uuids().put(multiplexed_player.new_uuid, multiplexed_player.original_uuid);
                break;
            }
            case PENDING_MULTIPLEXED_LOGINS: {
                this.plugin.get_pending_multiplexer_logins().put(uuid, multiplexed_player);
            }
        }
    }

    public abstract boolean implementation_specific_auth(MultiplexedPlayer var1);

    public static void register_auth_multiplex_player(IVaneProxyServerInfo server, MultiplexedPlayer multiplexed_player) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(stream);
        try {
            out.writeInt(multiplexed_player.multiplexer_id);
            out.writeUTF(multiplexed_player.original_uuid.toString());
            out.writeUTF(multiplexed_player.name);
            out.writeUTF(multiplexed_player.new_uuid.toString());
            out.writeUTF(multiplexed_player.new_name);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        server.sendData(stream.toByteArray());
    }

    public static class MultiplexedPlayer {
        public Integer multiplexer_id;
        public String name;
        public String new_name;
        public UUID original_uuid;
        public UUID new_uuid;

        public MultiplexedPlayer(Integer multiplexer_id, String name, String new_name, UUID original_uuid, UUID new_uuid) {
            this.multiplexer_id = multiplexer_id;
            this.name = name;
            this.new_name = new_name;
            this.original_uuid = original_uuid;
            this.new_uuid = new_uuid;
        }
    }

    public static enum PreLoginDestination {
        MULTIPLEXED_UUIDS,
        PENDING_MULTIPLEXED_LOGINS;

    }
}

