/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.proxycore.util;

import java.util.HashMap;
import java.util.Map;

public class TimeUtil {
    private static Map<Character, Long> time_multiplier;

    public static long parse_time(String input) throws NumberFormatException {
        long ret = 0L;
        for (String time : input.split("(?<=[^0-9])(?=[0-9])")) {
            String[] content = time.split("(?=[^0-9])");
            if (content.length != 2) {
                throw new NumberFormatException("missing multiplier");
            }
            Long mult = time_multiplier.get(Character.valueOf(content[1].replace("and", "").replaceAll("[,+\\.\\s]+", "").charAt(0)));
            if (mult == null) {
                throw new NumberFormatException("\"" + content[1] + "\" is not a valid multiplier");
            }
            ret += Long.parseLong(content[0]) * mult;
        }
        return ret;
    }

    public static String format_time(long millis) {
        Object ret = "";
        long days = millis / 86400000L;
        long hours = millis / 3600000L % 24L;
        long minutes = millis / 60000L % 60L;
        long seconds = millis / 1000L % 60L;
        if (days > 0L) {
            ret = (String)ret + days + "d";
        }
        if (hours > 0L) {
            ret = (String)ret + hours + "h";
        }
        if (minutes > 0L) {
            ret = (String)ret + minutes + "m";
        }
        if (seconds > 0L || ((String)ret).length() == 0) {
            ret = (String)ret + seconds + "s";
        }
        return ret;
    }

    static {
        HashMap<Character, Long> mult = new HashMap<Character, Long>();
        mult.put(Character.valueOf('s'), 1000L);
        mult.put(Character.valueOf('m'), 60000L);
        mult.put(Character.valueOf('h'), 3600000L);
        mult.put(Character.valueOf('d'), 86400000L);
        mult.put(Character.valueOf('w'), 604800000L);
        mult.put(Character.valueOf('y'), 31536000000L);
        time_multiplier = mult;
    }
}

