/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.event.EventManager;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.network.ConnectionManager;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import org.oddlama.vane.proxycore.VaneProxyPlugin;
import org.oddlama.vane.proxycore.config.AuthMultiplex;
import org.oddlama.vane.proxycore.log.slf4jCompatLogger;
import org.oddlama.vane.vane_velocity.external.bstats.velocity.Metrics;
import org.oddlama.velocity.commands.Maintenance;
import org.oddlama.velocity.commands.Ping;
import org.oddlama.velocity.compat.VelocityCompatProxyServer;
import org.oddlama.velocity.listeners.ProxyDisconnectListener;
import org.oddlama.velocity.listeners.ProxyGameProfileRequestListener;
import org.oddlama.velocity.listeners.ProxyLoginListener;
import org.oddlama.velocity.listeners.ProxyPingListener;
import org.oddlama.velocity.listeners.ProxyPreLoginListener;
import org.slf4j.Logger;

@Plugin(id="vane-velocity", name="Vane Velocity", version="$VERSION", description="TODO", authors={"oddlama", "Serial-ATA"}, url="https://github.com/oddlama/vane")
public class Velocity
extends VaneProxyPlugin {
    public static final MinecraftChannelIdentifier CHANNEL = MinecraftChannelIdentifier.create((String)"vane_proxy", (String)"auth_multiplex");
    private final ProxyServer velocity_server;
    private final Metrics.Factory metricsFactory;

    @Inject
    public Velocity(ProxyServer server, Logger logger, Metrics.Factory metricsFactory, @DataDirectory Path data_dir) {
        this.server = new VelocityCompatProxyServer(server);
        this.logger = new slf4jCompatLogger(logger);
        this.metricsFactory = metricsFactory;
        this.velocity_server = server;
        this.data_dir = data_dir.toFile();
    }

    public ProxyServer get_raw_proxy() {
        return this.velocity_server;
    }

    @Subscribe
    public void on_enable(ProxyInitializeEvent event) {
        if (!this.config.load()) {
            this.disable();
            return;
        }
        this.metricsFactory.make(this, 8891);
        EventManager event_manager = this.velocity_server.getEventManager();
        event_manager.register((Object)this, (Object)new ProxyPingListener(this));
        event_manager.register((Object)this, (Object)new ProxyPreLoginListener(this));
        event_manager.register((Object)this, (Object)new ProxyGameProfileRequestListener(this));
        event_manager.register((Object)this, (Object)new ProxyLoginListener(this));
        event_manager.register((Object)this, (Object)new ProxyDisconnectListener(this));
        this.maintenance.load();
        CommandManager command_manager = this.velocity_server.getCommandManager();
        CommandMeta ping_meta = command_manager.metaBuilder("ping").build();
        command_manager.register(ping_meta, (Command)new Ping(this));
        CommandMeta maintenance_meta = command_manager.metaBuilder("maintenance").build();
        command_manager.register(maintenance_meta, (Command)new Maintenance(this));
        this.velocity_server.getChannelRegistrar().register(new ChannelIdentifier[]{CHANNEL});
        if (!this.config.multiplexer_by_id.isEmpty()) {
            try {
                this.get_logger().log(Level.INFO, "Attempting to register auth multiplexers");
                this.handle_listeners("Registering", ConnectionManager::bind);
            }
            catch (Exception e) {
                this.get_logger().log(Level.SEVERE, "Failed to inject into VelocityServer!", e);
                this.disable();
            }
        }
    }

    @Subscribe
    public void on_disable(ProxyShutdownEvent event) {
        this.disable();
    }

    private void disable() {
        this.velocity_server.getEventManager().unregisterListeners((Object)this);
        this.velocity_server.getChannelRegistrar().unregister(new ChannelIdentifier[]{CHANNEL});
        try {
            this.get_logger().log(Level.INFO, "Attempting to close auth multiplexers");
            this.handle_listeners("Closing", ConnectionManager::close);
        }
        catch (Exception e) {
            this.get_logger().log(Level.SEVERE, "Failed to stop listeners!", e);
            this.get_logger().log(Level.SEVERE, "Shutting down the server to prevent lingering unmanaged listeners!");
            this.velocity_server.shutdown();
        }
        this.server = null;
        this.logger = null;
    }

    private void handle_listeners(String action, BiConsumer<? super ConnectionManager, ? super InetSocketAddress> method) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        VelocityServer server = (VelocityServer)this.velocity_server;
        Class<?> velocity_server = Class.forName("com.velocitypowered.proxy.VelocityServer");
        Field cm_field = velocity_server.getDeclaredField("cm");
        cm_field.setAccessible(true);
        ConnectionManager cm = (ConnectionManager)cm_field.get(server);
        for (Map.Entry<Integer, AuthMultiplex> multiplexer_map : this.config.multiplexer_by_id.entrySet()) {
            Integer id = multiplexer_map.getKey();
            Integer port = multiplexer_map.getValue().port;
            this.get_logger().log(Level.INFO, action + " multiplexer ID " + id + ", bound to port " + port);
            InetSocketAddress address = new InetSocketAddress(port);
            method.accept((ConnectionManager)cm, address);
        }
    }
}

