/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.velocity.compat.event;

import com.velocitypowered.api.proxy.InboundConnection;
import com.velocitypowered.api.proxy.Player;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;
import org.oddlama.vane.proxycore.ProxyPendingConnection;
import org.oddlama.vane.proxycore.ProxyServer;

public class VelocityCompatPendingConnection
implements ProxyPendingConnection {
    final InboundConnection connection;
    final String username;
    final UUID uuid;

    public VelocityCompatPendingConnection(InboundConnection connection, String username) {
        this.connection = connection;
        this.username = username;
        this.uuid = null;
    }

    public VelocityCompatPendingConnection(Player player) {
        this.connection = player;
        this.username = player.getUsername();
        this.uuid = player.getUniqueId();
    }

    @Override
    public String get_name() {
        return this.username;
    }

    @Override
    @Nullable
    public UUID get_unique_id() {
        return this.uuid;
    }

    @Override
    public int get_port() {
        return ((InetSocketAddress)this.connection.getVirtualHost().get()).getPort();
    }

    @Override
    public SocketAddress get_socket_address() {
        return (SocketAddress)this.connection.getVirtualHost().get();
    }

    @Override
    public boolean has_permission(ProxyServer server, String ... permission) {
        return Arrays.stream(permission).anyMatch(perm -> ((Player)this.connection).hasPermission(perm));
    }
}

