/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.velocity.listeners;

import com.velocitypowered.api.event.PostOrder;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.player.GameProfileRequestEvent;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.util.GameProfile;
import java.net.InetSocketAddress;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import org.oddlama.vane.proxycore.config.AuthMultiplex;
import org.oddlama.vane.proxycore.listeners.PreLoginEvent;
import org.oddlama.velocity.Util;
import org.oddlama.velocity.Velocity;
import org.oddlama.velocity.compat.VelocityCompatServerInfo;

public class ProxyGameProfileRequestListener {
    final Velocity velocity;

    public ProxyGameProfileRequestListener(Velocity velocity) {
        this.velocity = velocity;
    }

    @Subscribe(order=PostOrder.LAST)
    public void game_profile_request(GameProfileRequestEvent event) {
        Optional virtual_host = event.getConnection().getVirtualHost();
        if (virtual_host.isEmpty()) {
            return;
        }
        Map.Entry<Integer, AuthMultiplex> multiplexer = this.velocity.get_config().get_multiplexer_for_port(((InetSocketAddress)virtual_host.get()).getPort());
        if (multiplexer == null) {
            return;
        }
        LinkedHashMap<UUID, PreLoginEvent.MultiplexedPlayer> pending_multiplexer_logins = this.velocity.get_pending_multiplexer_logins();
        if (pending_multiplexer_logins.isEmpty()) {
            return;
        }
        GameProfile profile = event.getGameProfile();
        UUID target_uuid = profile.getId();
        PreLoginEvent.MultiplexedPlayer player = (PreLoginEvent.MultiplexedPlayer)pending_multiplexer_logins.remove(target_uuid);
        if (player == null) {
            this.velocity.get_logger().log(Level.WARNING, "Unregistered multiplexer connection managed to get through!");
            return;
        }
        GameProfile tampered_profile = new GameProfile(player.new_uuid, player.new_name, profile.getProperties());
        event.setGameProfile(tampered_profile);
        RegisteredServer server = Util.get_server_for_host(this.velocity.get_raw_proxy(), (InetSocketAddress)virtual_host.get());
        VelocityCompatServerInfo server_info = new VelocityCompatServerInfo(server);
        PreLoginEvent.register_auth_multiplex_player(server_info, player);
        this.velocity.get_multiplexed_uuids().put(player.new_uuid, player.original_uuid);
    }
}

