/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.velocity.listeners;

import com.google.inject.Inject;
import com.velocitypowered.api.event.PostOrder;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.LoginEvent;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.net.InetSocketAddress;
import java.util.Optional;
import org.oddlama.velocity.Util;
import org.oddlama.velocity.Velocity;
import org.oddlama.velocity.compat.VelocityCompatServerInfo;
import org.oddlama.velocity.compat.event.VelocityCompatLoginEvent;
import org.oddlama.velocity.compat.event.VelocityCompatPendingConnection;

public class ProxyLoginListener {
    final Velocity velocity;

    @Inject
    public ProxyLoginListener(Velocity velocity) {
        this.velocity = velocity;
    }

    @Subscribe(order=PostOrder.LAST)
    public void login(LoginEvent event) {
        if (!event.getResult().isAllowed()) {
            return;
        }
        ProxyServer proxy = this.velocity.get_raw_proxy();
        Optional virtual_host = event.getPlayer().getVirtualHost();
        if (virtual_host.isEmpty()) {
            return;
        }
        RegisteredServer server = Util.get_server_for_host(proxy, (InetSocketAddress)virtual_host.get());
        VelocityCompatServerInfo server_info = new VelocityCompatServerInfo(server);
        VelocityCompatLoginEvent proxy_event = new VelocityCompatLoginEvent(event, this.velocity, server_info, new VelocityCompatPendingConnection(event.getPlayer()));
        proxy_event.fire();
    }
}

