/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resourceconfigapi.client.gui.screen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.tabs.Tab;
import net.minecraft.client.gui.components.tabs.TabManager;
import net.minecraft.client.gui.components.tabs.TabNavigationBar;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.xstopho.resourceconfigapi.ConfigConstants;
import net.xstopho.resourceconfigapi.api.ConfigRegistry;
import net.xstopho.resourceconfigapi.api.ConfigType;
import net.xstopho.resourceconfigapi.client.ClientConstants;
import net.xstopho.resourceconfigapi.client.gui.widget.ConfigTab;
import net.xstopho.resourceconfigapi.client.gui.widget.value_list.base.BaseEntry;
import net.xstopho.resourceconfigapi.client.util.ClientUtils;
import net.xstopho.resourceconfigapi.client.util.ComponentUtils;
import net.xstopho.resourceconfigapi.client.util.GuiUtils;
import net.xstopho.resourceconfigapi.config.ConfigHolder;
import net.xstopho.resourceconfigapi.config.ModConfig;

public class ResourceConfigScreen
extends Screen {
    private final HeaderAndFooterLayout layout;
    private final Screen previous;
    private final String modId;
    private final TabManager manager;
    private TabNavigationBar navigationBar;
    private final Map<ResourceLocation, ConfigHolder> configs = new HashMap<ResourceLocation, ConfigHolder>();
    private final List<ClientTooltipComponent> tooltips = new ArrayList<ClientTooltipComponent>();
    private final ConfigTab commonTab;
    private final ConfigTab clientTab;
    private final ConfigTab serverTab;

    public ResourceConfigScreen(Screen previous, String modId) {
        super((Component)Component.literal((String)("Config Screen - " + modId)));
        this.modId = modId;
        this.previous = previous;
        this.layout = new HeaderAndFooterLayout((Screen)this, 32, 32);
        this.manager = new TabManager(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        }, x$0 -> this.removeWidget((GuiEventListener)x$0));
        ConfigRegistry.getConfigs().forEach(this::processConfigs);
        this.commonTab = new ConfigTab(ConfigType.COMMON, this.configs);
        this.clientTab = new ConfigTab(ConfigType.CLIENT, this.configs);
        this.serverTab = new ConfigTab(ConfigType.SERVER, this.configs);
    }

    protected void init() {
        TabNavigationBar.Builder builder = TabNavigationBar.builder((TabManager)this.manager, (int)this.width);
        if (this.clientTab.containsConfigs()) {
            builder.addTabs(new Tab[]{this.clientTab});
        }
        if (this.commonTab.containsConfigs() && ClientUtils.isOperator()) {
            builder.addTabs(new Tab[]{this.commonTab});
        }
        if (this.serverTab.containsConfigs() && ClientUtils.isOperator() && ClientUtils.isMultiplayer()) {
            builder.addTabs(new Tab[]{this.serverTab});
        }
        this.navigationBar = builder.build();
        LinearLayout footer = (LinearLayout)this.layout.addToFooter((LayoutElement)LinearLayout.horizontal().spacing(8));
        footer.addChild((LayoutElement)Button.builder((Component)ClientConstants.SAVE_AND_CLOSE, button -> {
            this.consumeAction(BaseEntry::saveValues);
            this.configs.forEach(this::saveConfigChanges);
            this.onClose();
        }).width(100).build());
        footer.addChild((LayoutElement)Button.builder((Component)ClientConstants.RESET_ALL, button -> this.consumeAction(BaseEntry::resetValues)).width(100).build());
        footer.addChild((LayoutElement)Button.builder((Component)ClientConstants.CLOSE, button -> {
            this.consumeAction(BaseEntry::undoChanges);
            this.onClose();
        }).width(100).build());
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        if (!this.navigationBar.children().isEmpty()) {
            this.addRenderableWidget((GuiEventListener)this.navigationBar);
            this.navigationBar.selectTab(0, true);
        }
        this.repositionElements();
        ComponentUtils.loggMissingTranslations(this.modId);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float ticks) {
        super.render(guiGraphics, mouseX, mouseY, ticks);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, Screen.FOOTER_SEPARATOR, 0, this.height - 35, 0.0f, 0.0f, this.width, 2, 32, 2);
        this.tooltips.forEach(tooltip -> guiGraphics.renderTooltip(GuiUtils.getFont(), List.of(tooltip), mouseX, mouseY, DefaultTooltipPositioner.INSTANCE, null));
        this.tooltips.clear();
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        if (keyEvent.key() == 256 && this.shouldCloseOnEsc()) {
            Minecraft.getInstance().setScreen(this.previous);
            return true;
        }
        return super.keyPressed(keyEvent);
    }

    protected void repositionElements() {
        if (this.navigationBar != null && !this.navigationBar.children().isEmpty()) {
            this.navigationBar.setWidth(this.width);
            this.navigationBar.arrangeElements();
            int i = this.navigationBar.getRectangle().bottom();
            ScreenRectangle screenRectangle = new ScreenRectangle(0, i, this.width, this.height - i * 2 - 10);
            this.manager.setTabArea(screenRectangle);
        }
        this.layout.arrangeElements();
    }

    public void onClose() {
        Minecraft.getInstance().setScreen(this.previous);
    }

    private void processConfigs(ResourceLocation location, ModConfig config) {
        if (location.getNamespace().equals(this.modId)) {
            this.configs.put(location, new ConfigHolder(config, this));
        }
    }

    private void saveConfigChanges(ResourceLocation location, ConfigHolder holder) {
        ModConfig config = holder.getConfig();
        if (ClientUtils.isMultiplayer()) {
            switch (config.configType) {
                case CLIENT: {
                    this.saveConfig(holder);
                    break;
                }
                case COMMON: 
                case SERVER: {
                    ClientUtils.sendConfigUpdateToServer(location.toString(), config.toJson().toString());
                }
            }
        } else {
            switch (config.configType) {
                case CLIENT: 
                case COMMON: {
                    this.saveConfig(holder);
                }
            }
        }
    }

    private void saveConfig(ConfigHolder holder) {
        ModConfig config = holder.getConfig();
        ConfigConstants.LOG.info("Saving '{}' config from mod '{}' of type '{}'", new Object[]{holder.getFileName(), config.modId, config.configType});
        config.writeConfig(config.toJson());
    }

    private void consumeAction(Consumer<BaseEntry> consumer) {
        for (Map.Entry<ResourceLocation, ConfigHolder> entry : this.configs.entrySet()) {
            entry.getValue().getEntryList().forEach(consumer);
        }
    }

    public void addTooltip(ClientTooltipComponent tooltipProvider) {
        this.tooltips.add(tooltipProvider);
    }
}

