/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resourceconfigapi.client.gui.widget.value_list.base;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.xstopho.resourceconfigapi.ConfigConstants;
import net.xstopho.resourceconfigapi.client.gui.screen.ResourceConfigScreen;
import net.xstopho.resourceconfigapi.client.gui.tooltip.ResourceTooltipProvider;
import net.xstopho.resourceconfigapi.client.util.ComponentUtils;
import net.xstopho.resourceconfigapi.client.util.GuiUtils;

public abstract class BaseEntry
extends ContainerObjectSelectionList.Entry<BaseEntry>
implements ResourceTooltipProvider {
    public final ResourceLocation undoSprite = ConfigConstants.of("textures/gui/sprites/icon/undo.png");
    private final int widgetWidth = 160;
    protected final List<AbstractWidget> children = new ArrayList<AbstractWidget>();
    protected final Font font = GuiUtils.getFont();
    protected final Component label;
    protected final Component tooltip;
    protected final ResourceConfigScreen screen;

    public BaseEntry(ResourceConfigScreen screen, String modId, String fileName, String key, ChatFormatting chatFormatting) {
        this.label = ComponentUtils.modLabel(modId, fileName, key).copy().withStyle(chatFormatting);
        this.tooltip = ComponentUtils.modTooltip(modId, fileName, key);
        this.screen = screen;
    }

    public List<? extends NarratableEntry> narratables() {
        return this.children;
    }

    public List<? extends GuiEventListener> children() {
        return this.children;
    }

    public abstract void renderContent(GuiGraphics var1, int var2, int var3, boolean var4, float var5);

    public Font getFont() {
        return this.font;
    }

    public int getWidgetWidth() {
        return 160;
    }

    public void saveValues() {
    }

    public void undoChanges() {
    }

    public void resetValues() {
    }

    @Override
    public ClientTooltipComponent getTooltip() {
        return GuiUtils.createTooltip(this.tooltip);
    }
}

