/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resourceconfigapi.api;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.xstopho.resourceconfigapi.annotations.Config;
import net.xstopho.resourceconfigapi.api.ConfigType;
import net.xstopho.resourceconfigapi.config.ModConfig;

public class ConfigRegistry {
    private static final Map<ResourceLocation, ModConfig> CONFIGS = new HashMap<ResourceLocation, ModConfig>();

    public static ModConfig register(Class<?> clazz, String modId) {
        if (!clazz.isAnnotationPresent(Config.class)) {
            String error = "You try to register '%s', this class isn't flagged as a Config and was skipped!";
            throw new IllegalArgumentException(String.format(error, clazz.getName()));
        }
        Config annotation = clazz.getAnnotation(Config.class);
        ResourceLocation config = ConfigRegistry.of(modId, annotation.type(), annotation.fileName());
        return CONFIGS.putIfAbsent(config, new ModConfig(clazz, annotation.type(), modId));
    }

    public static ModConfig getConfig(ResourceLocation configLocation) {
        return CONFIGS.get(configLocation);
    }

    public static boolean contains(ResourceLocation configLocation) {
        return CONFIGS.containsKey(configLocation);
    }

    public static Map<ResourceLocation, ModConfig> getConfigs() {
        return CONFIGS;
    }

    public static Set<Map.Entry<ResourceLocation, ModConfig>> getConfigEntries() {
        return ConfigRegistry.getConfigs().entrySet();
    }

    private static ResourceLocation of(String modId, ConfigType type, String fileName) {
        return ResourceLocation.fromNamespaceAndPath((String)modId, (String)(type.name().toLowerCase(Locale.ENGLISH) + "/" + fileName));
    }
}

