/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resourceconfigapi.client.gui.widget.value_list.entries;

import java.lang.reflect.Field;
import java.util.Objects;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.xstopho.resourceconfigapi.client.ClientConstants;
import net.xstopho.resourceconfigapi.client.gui.widget.value_list.base.ButtonValueEntry;
import net.xstopho.resourceconfigapi.client.util.GuiUtils;

public class BooleanValueEntry
extends ButtonValueEntry<Boolean> {
    private boolean state = (Boolean)this.getFieldValue();

    public BooleanValueEntry(String modId, String fileName, String translationKey, Field field, Object defaultValue) {
        super(modId, fileName, translationKey, field, defaultValue);
        this.valueButton = Button.builder((Component)(this.state ? ClientConstants.BOOLEAN_ENABLED : ClientConstants.BOOLEAN_DISABLED), this::changeState).tooltip(GuiUtils.hasTranslation(this.tooltip) ? Tooltip.create((Component)this.tooltip) : null).bounds(0, 0, this.getWidgetWidth(), 20).build();
        this.children.add(this.valueButton);
    }

    private void changeState(Button button) {
        this.state = !this.state;
        button.setMessage(this.state ? ClientConstants.BOOLEAN_ENABLED : ClientConstants.BOOLEAN_DISABLED);
        this.changeUndoState(!Objects.equals(this.state, this.getFieldValue()));
    }

    @Override
    public Boolean getValue() {
        return this.state;
    }

    @Override
    public void undoChanges() {
        this.state = (Boolean)this.getFieldValue();
        this.valueButton.setMessage(this.state ? ClientConstants.BOOLEAN_ENABLED : ClientConstants.BOOLEAN_DISABLED);
        this.changeUndoState(false);
    }

    @Override
    public void resetValues() {
        this.state = (Boolean)this.defaultValue;
        this.valueButton.setMessage(this.state ? ClientConstants.BOOLEAN_ENABLED : ClientConstants.BOOLEAN_DISABLED);
        this.changeUndoState(!Objects.equals(this.state, this.getFieldValue()));
        super.resetValues();
    }
}

