/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resourceconfigapi.client.gui.widget;

import java.util.function.Consumer;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class RangedEntrySlider
extends AbstractSliderButton {
    private final double minValue;
    private final double maxValue;
    private final double currentValue;
    private final boolean integer;
    private Consumer<Double> responder;

    public RangedEntrySlider(int width, double currentValue, double minValue, double maxValue, boolean integer) {
        super(0, 0, width, 20, (Component)Component.empty(), (currentValue - minValue) / (maxValue - minValue));
        this.currentValue = currentValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.integer = integer;
        this.updateMessage();
    }

    protected void updateMessage() {
        if (this.integer) {
            this.setMessage((Component)Component.literal((String)String.valueOf((int)this.getValue())));
            return;
        }
        this.setMessage((Component)Component.literal((String)String.format("%.2f", this.getValue())));
    }

    protected void applyValue() {
        if (this.responder != null) {
            this.responder.accept(this.getValue());
        }
    }

    public RangedEntrySlider setResponder(Consumer<Double> consumer) {
        this.responder = consumer;
        return this;
    }

    public double getValue() {
        double clampedValue = Mth.clampedLerp((double)this.minValue, (double)this.maxValue, (double)this.value);
        if (this.maxValue > 1.0) {
            clampedValue = (double)Math.round(clampedValue / 0.1) * 0.1;
        }
        return clampedValue;
    }

    public void undoValue() {
        this.value = this.currentValue / this.maxValue;
        this.updateMessage();
    }

    public void setValue(double doubleValue) {
        this.value = doubleValue / this.maxValue;
        this.updateMessage();
        this.applyValue();
    }
}

