/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resourceconfigapi.client.gui.widget.value_list.base;

import java.lang.reflect.Field;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.xstopho.resourceconfigapi.client.ClientConstants;
import net.xstopho.resourceconfigapi.client.gui.widget.value_list.base.BaseEntry;
import net.xstopho.resourceconfigapi.client.util.GuiUtils;

public abstract class ButtonValueEntry<T>
extends BaseEntry {
    protected final Object defaultValue;
    private final Field field;
    private final Button reset;
    private final Button undo;
    protected Button valueButton;

    public ButtonValueEntry(String modId, String fileName, String key, Field field, Object defaultValue) {
        super(modId, fileName, key, ChatFormatting.WHITE);
        this.defaultValue = defaultValue;
        this.field = field;
        this.reset = Button.builder((Component)ClientConstants.RESET, button -> this.resetValues()).tooltip(GuiUtils.hasTranslation(ClientConstants.RESET_TOOLTIP) ? Tooltip.create((Component)ClientConstants.RESET_TOOLTIP) : null).bounds(0, 0, 50, 20).build();
        this.undo = Button.builder((Component)Component.empty(), button -> this.undoChanges()).tooltip(GuiUtils.hasTranslation(ClientConstants.UNDO_TOOLTIP) ? Tooltip.create((Component)ClientConstants.UNDO_TOOLTIP) : null).bounds(0, 0, 20, 20).build();
        this.undo.active = false;
        this.children.add(this.reset);
        this.children.add(this.undo);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int index, int yPos, int xPos, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float delta) {
        GuiUtils.drawStringWithTooltip(guiGraphics, this.label, this.tooltip, xPos + 13, yPos + 6, mouseX, mouseY);
        this.undo.setPosition(xPos + rowWidth - this.undo.getWidth() - this.reset.getWidth(), yPos);
        this.reset.setPosition(xPos + rowWidth - this.reset.getWidth(), yPos);
        this.valueButton.setPosition(xPos + rowWidth - this.getWidgetWidth(), yPos);
        this.valueButton.setWidth(this.getWidgetWidth() - (this.undo.getWidth() + this.reset.getWidth()) - 1);
        this.valueButton.render(guiGraphics, mouseX, mouseY, delta);
        this.reset.render(guiGraphics, mouseX, mouseY, delta);
        this.undo.render(guiGraphics, mouseX, mouseY, delta);
        guiGraphics.blit(RenderType::guiTextured, this.undoSprite, this.undo.getX() + 2, this.undo.getY() + 2, 0.0f, 0.0f, 16, 16, 16, 16);
        GuiUtils.renderIcon(guiGraphics, this.field, xPos, yPos + 4, mouseX, mouseY);
    }

    public abstract T getValue();

    @Override
    public void undoChanges() {
        this.undo.active = false;
    }

    @Override
    public void resetValues() {
        try {
            this.field.set(this.field, this.defaultValue);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to set default value for field: " + this.field.getName() + "\n" + String.valueOf(e));
        }
    }

    @Override
    public void saveValues() {
        try {
            this.field.set(this.field, this.getValue());
            this.undo.active = false;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(String.format("Failed to save new Value for Field %s", this.field.getName()));
        }
    }

    protected void changeUndoState(boolean state) {
        this.undo.active = state;
    }

    protected T getFieldValue() {
        try {
            return (T)this.field.get(null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(String.format("Failed to get Value for Field '%s'", this.field.getName()));
        }
    }
}

