/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resourceconfigapi.network.payloads;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.xstopho.resourceconfigapi.ConfigConstants;
import net.xstopho.resourceconfigapi.api.ConfigRegistry;
import net.xstopho.resourceconfigapi.config.ModConfig;
import net.xstopho.resourceconfigapi.network.ConfigNetwork;
import net.xstopho.resourceconfigapi.network.payloads.ConfigSyncPayload;

public record ConfigUpdatePayload(String file, String json) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ConfigUpdatePayload> TYPE = ConfigConstants.type("config_update_payload");
    public static final StreamCodec<RegistryFriendlyByteBuf, ConfigUpdatePayload> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, ConfigUpdatePayload::file, (StreamCodec)ByteBufCodecs.STRING_UTF8, ConfigUpdatePayload::json, ConfigUpdatePayload::new);

    public static void handle(ConfigUpdatePayload payload, MinecraftServer server) {
        if (server == null || payload.file().contains("client")) {
            return;
        }
        server.execute(() -> {
            JsonObject jsonObject = JsonParser.parseString((String)payload.json()).getAsJsonObject();
            ResourceLocation configLocation = ResourceLocation.parse((String)payload.file());
            if (ConfigRegistry.contains(configLocation)) {
                ConfigConstants.LOG.info("Receive update for Config: {}", (Object)configLocation);
                ModConfig config = ConfigRegistry.getConfig(configLocation);
                config.fromJson(jsonObject);
                config.save();
            }
            ConfigConstants.LOG.info("Sync config changes with Player");
            server.getPlayerList().getPlayers().forEach(player -> ConfigNetwork.INSTANCE.sendToClient((ServerPlayer)player, new ConfigSyncPayload(payload.file(), payload.json())));
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

