/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resourceconfigapi.client.gui.widget;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.tabs.Tab;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.xstopho.resourceconfigapi.api.ConfigType;
import net.xstopho.resourceconfigapi.client.gui.widget.config_list.ConfigListEntry;
import net.xstopho.resourceconfigapi.client.gui.widget.config_list.ConfigListWidget;
import net.xstopho.resourceconfigapi.client.gui.widget.value_list.ValueListWidget;
import net.xstopho.resourceconfigapi.client.util.ComponentUtils;
import net.xstopho.resourceconfigapi.config.ConfigHolder;

public class ConfigTab
implements Tab {
    private final List<ConfigHolder> configHolderList = new ArrayList<ConfigHolder>();
    private final ConfigListWidget configListWidget;
    private final ValueListWidget valueListWidget;
    private final ConfigType type;

    public ConfigTab(ConfigType type, Map<ResourceLocation, ConfigHolder> configs) {
        this.type = type;
        configs.forEach(this::processConfigs);
        this.valueListWidget = new ValueListWidget(0, 0, 0, 24);
        this.configListWidget = new ConfigListWidget(0, 0, 0, 15, this.configHolderList, this.valueListWidget);
        this.configListWidget.setSelectedIndex(0);
        ConfigListEntry entry = (ConfigListEntry)this.configListWidget.getSelected();
        if (entry != null && entry.getEntryList() != null) {
            this.valueListWidget.replaceEntries(entry.getEntryList());
        }
    }

    private void processConfigs(ResourceLocation location, ConfigHolder configHolder) {
        String configType = location.getPath().split("/")[0];
        if (configType.equalsIgnoreCase(this.type.name())) {
            this.configHolderList.add(configHolder);
        }
    }

    public Component getTabTitle() {
        return ComponentUtils.title(this.type.name().toLowerCase());
    }

    public Component getTabExtraNarration() {
        return Component.literal((String)this.type.name());
    }

    public void visitChildren(Consumer<AbstractWidget> consumer) {
        consumer.accept((AbstractWidget)this.configListWidget);
        consumer.accept((AbstractWidget)this.valueListWidget);
    }

    public void doLayout(ScreenRectangle screenRectangle) {
        this.configListWidget.setRectangle(100, screenRectangle.height() - 13, 5, 30);
        this.valueListWidget.setRectangle(screenRectangle.width() - this.configListWidget.getWidth() - 15, screenRectangle.height() - 11, 125, 29);
    }

    public boolean containsConfigs() {
        return !this.configHolderList.isEmpty();
    }
}

