/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resourceconfigapi.client.gui.widget.value_list.base;

import java.lang.reflect.Field;
import java.util.Objects;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.xstopho.resourceconfigapi.annotations.RangedEntry;
import net.xstopho.resourceconfigapi.client.ClientConstants;
import net.xstopho.resourceconfigapi.client.gui.screen.ResourceConfigScreen;
import net.xstopho.resourceconfigapi.client.gui.widget.RangedEntrySlider;
import net.xstopho.resourceconfigapi.client.gui.widget.value_list.base.BaseEntry;
import net.xstopho.resourceconfigapi.client.util.GuiUtils;

public abstract class NumberValueEntry<T>
extends BaseEntry {
    private final Object defaultValue;
    protected final Field field;
    private final Button reset;
    private final Button undo;
    protected AbstractWidget valueWidget;

    public NumberValueEntry(ResourceConfigScreen screen, String modId, String fileName, String key, Field field, Object defaultValue, boolean integer, Pattern pattern) {
        super(screen, modId, fileName, key, ChatFormatting.WHITE);
        this.defaultValue = defaultValue;
        this.field = field;
        this.reset = Button.builder((Component)ClientConstants.RESET, button -> this.resetValues()).tooltip(GuiUtils.hasTranslation(ClientConstants.RESET_TOOLTIP) ? Tooltip.create((Component)ClientConstants.RESET_TOOLTIP) : null).bounds(0, 0, 50, 20).build();
        this.undo = Button.builder((Component)Component.empty(), button -> this.undoChanges()).tooltip(GuiUtils.hasTranslation(ClientConstants.UNDO_TOOLTIP) ? Tooltip.create((Component)ClientConstants.UNDO_TOOLTIP) : null).bounds(0, 0, 20, 20).build();
        this.undo.active = false;
        if (field.isAnnotationPresent(RangedEntry.class)) {
            RangedEntry range = field.getAnnotation(RangedEntry.class);
            this.valueWidget = new RangedEntrySlider(this.getWidgetWidth(), Double.parseDouble(this.getFieldValue().toString()), range.minValue(), range.maxValue(), integer).setResponder(aDouble -> {
                this.undo.active = !Objects.equals(aDouble, this.getFieldValue());
            });
        } else {
            this.valueWidget = new EditBox(this.getFont(), this.getWidgetWidth(), 18, (Component)Component.empty());
            ((EditBox)this.valueWidget).setResponder(s -> {
                this.undo.active = !Objects.equals(s, this.getFieldValue().toString());
            });
            ((EditBox)this.valueWidget).setFilter(s -> pattern.matcher((CharSequence)s).matches());
            ((EditBox)this.valueWidget).setValue(this.getFieldValue().toString());
        }
        this.children.add(this.valueWidget);
        this.children.add(this.reset);
        this.children.add(this.undo);
    }

    @Override
    public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovered, float delta) {
        GuiUtils.drawStringWithTooltip(this.screen, this, guiGraphics, this.label, this.tooltip, this.getContentX() + 13, this.getContentY() + 6, mouseX, mouseY);
        this.undo.setPosition(this.getContentX() + this.getContentWidth() - this.undo.getWidth() - this.reset.getWidth(), this.getContentY());
        this.reset.setPosition(this.getContentX() + this.getContentWidth() - this.reset.getWidth(), this.getContentY());
        this.valueWidget.setPosition(this.getContentX() + this.getContentWidth() - this.getWidgetWidth(), this.getContentY() + 1);
        this.valueWidget.setWidth(this.getWidgetWidth() - (this.undo.getWidth() + this.reset.getWidth()) - 1);
        this.valueWidget.render(guiGraphics, mouseX, mouseY, delta);
        this.reset.render(guiGraphics, mouseX, mouseY, delta);
        this.undo.render(guiGraphics, mouseX, mouseY, delta);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.undoSprite, this.undo.getX() + 2, this.undo.getY() + 2, 0.0f, 0.0f, 16, 16, 16, 16);
        GuiUtils.renderIcon(this.screen, guiGraphics, this.field, this.getContentX(), this.getContentY() + 4, mouseX, mouseY);
    }

    public abstract T getValue();

    @Override
    public void undoChanges() {
        AbstractWidget abstractWidget = this.valueWidget;
        if (abstractWidget instanceof RangedEntrySlider) {
            RangedEntrySlider slider = (RangedEntrySlider)abstractWidget;
            slider.undoValue();
        }
        if ((abstractWidget = this.valueWidget) instanceof EditBox) {
            EditBox editBox = (EditBox)abstractWidget;
            editBox.setValue(this.getFieldValue().toString());
        }
        this.undo.active = false;
    }

    @Override
    public void resetValues() {
        AbstractWidget abstractWidget = this.valueWidget;
        if (abstractWidget instanceof RangedEntrySlider) {
            RangedEntrySlider slider = (RangedEntrySlider)abstractWidget;
            slider.setValue(Double.parseDouble(this.defaultValue.toString()));
        }
        if ((abstractWidget = this.valueWidget) instanceof EditBox) {
            EditBox editBox = (EditBox)abstractWidget;
            editBox.setValue(this.defaultValue.toString());
        }
        try {
            this.field.set(this.field, this.defaultValue);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to set default value for field: " + this.field.getName() + "\n" + String.valueOf(e));
        }
    }

    @Override
    public void saveValues() {
        try {
            this.field.set(this.field, this.getValue());
            this.undo.active = false;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(String.format("Failed to save new Value for Field %s", this.field.getName()));
        }
    }

    protected T getFieldValue() {
        try {
            return (T)this.field.get(null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(String.format("Failed to get Value for Field '%s'", this.field.getName()));
        }
    }
}

