/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resourceconfigapi.client.gui.widget.value_list.base;

import java.lang.reflect.Field;
import java.util.Objects;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_7919;
import net.xstopho.resourceconfigapi.annotations.RangedEntry;
import net.xstopho.resourceconfigapi.client.ClientConstants;
import net.xstopho.resourceconfigapi.client.gui.widget.RangedEntrySlider;
import net.xstopho.resourceconfigapi.client.gui.widget.value_list.base.BaseEntry;
import net.xstopho.resourceconfigapi.client.util.GuiUtils;

public abstract class NumberValueEntry<T>
extends BaseEntry {
    private final Object defaultValue;
    protected final Field field;
    private final class_4185 reset;
    private final class_4185 undo;
    protected class_339 valueWidget;

    public NumberValueEntry(String modId, String fileName, String key, Field field, Object defaultValue, boolean integer, Pattern pattern) {
        super(modId, fileName, key, class_124.field_1068);
        this.defaultValue = defaultValue;
        this.field = field;
        this.reset = class_4185.method_46430((class_2561)ClientConstants.RESET, button -> this.resetValues()).method_46436(GuiUtils.hasTranslation(ClientConstants.RESET_TOOLTIP) ? class_7919.method_47407((class_2561)ClientConstants.RESET_TOOLTIP) : null).method_46434(0, 0, 50, 20).method_46431();
        this.undo = class_4185.method_46430((class_2561)class_2561.method_43473(), button -> this.undoChanges()).method_46436(GuiUtils.hasTranslation(ClientConstants.UNDO_TOOLTIP) ? class_7919.method_47407((class_2561)ClientConstants.UNDO_TOOLTIP) : null).method_46434(0, 0, 20, 20).method_46431();
        this.undo.field_22763 = false;
        if (field.isAnnotationPresent(RangedEntry.class)) {
            RangedEntry range = field.getAnnotation(RangedEntry.class);
            this.valueWidget = new RangedEntrySlider(this.getWidgetWidth(), Double.parseDouble(this.getFieldValue().toString()), range.minValue(), range.maxValue(), integer).setResponder(aDouble -> {
                this.undo.field_22763 = !Objects.equals(aDouble, this.getFieldValue());
            });
        } else {
            this.valueWidget = new class_342(this.getFont(), this.getWidgetWidth(), 18, (class_2561)class_2561.method_43473());
            ((class_342)this.valueWidget).method_1863(s -> {
                this.undo.field_22763 = !Objects.equals(s, this.getFieldValue().toString());
            });
            ((class_342)this.valueWidget).method_1890(s -> pattern.matcher((CharSequence)s).matches());
            ((class_342)this.valueWidget).method_1852(this.getFieldValue().toString());
        }
        this.children.add(this.valueWidget);
        this.children.add(this.reset);
        this.children.add(this.undo);
    }

    @Override
    public void method_25343(class_332 guiGraphics, int index, int yPos, int xPos, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float delta) {
        GuiUtils.drawStringWithTooltip(guiGraphics, this.label, this.tooltip, xPos + 13, yPos + 6, mouseX, mouseY);
        this.undo.method_48229(xPos + rowWidth - this.undo.method_25368() - this.reset.method_25368(), yPos);
        this.reset.method_48229(xPos + rowWidth - this.reset.method_25368(), yPos);
        this.valueWidget.method_48229(xPos + rowWidth - this.getWidgetWidth(), yPos);
        this.valueWidget.method_25358(this.getWidgetWidth() - (this.undo.method_25368() + this.reset.method_25368()) - 1);
        this.valueWidget.method_25394(guiGraphics, mouseX, mouseY, delta);
        this.reset.method_25394(guiGraphics, mouseX, mouseY, delta);
        this.undo.method_25394(guiGraphics, mouseX, mouseY, delta);
        guiGraphics.method_25290(this.undoSprite, this.undo.method_46426() + 2, this.undo.method_46427() + 2, 0.0f, 0.0f, 16, 16, 16, 16);
        GuiUtils.renderIcon(guiGraphics, this.field, xPos, yPos + 4, mouseX, mouseY);
    }

    public abstract T getValue();

    @Override
    public void undoChanges() {
        class_339 class_3392 = this.valueWidget;
        if (class_3392 instanceof RangedEntrySlider) {
            RangedEntrySlider slider = (RangedEntrySlider)class_3392;
            slider.undoValue();
        }
        if ((class_3392 = this.valueWidget) instanceof class_342) {
            class_342 editBox = (class_342)class_3392;
            editBox.method_1852(this.getFieldValue().toString());
        }
        this.undo.field_22763 = false;
    }

    @Override
    public void resetValues() {
        class_339 class_3392 = this.valueWidget;
        if (class_3392 instanceof RangedEntrySlider) {
            RangedEntrySlider slider = (RangedEntrySlider)class_3392;
            slider.setValue(Double.parseDouble(this.defaultValue.toString()));
        }
        if ((class_3392 = this.valueWidget) instanceof class_342) {
            class_342 editBox = (class_342)class_3392;
            editBox.method_1852(this.defaultValue.toString());
        }
        try {
            this.field.set(this.field, this.defaultValue);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to set default value for field: " + this.field.getName() + "\n" + String.valueOf(e));
        }
    }

    @Override
    public void saveValues() {
        try {
            this.field.set(this.field, this.getValue());
            this.undo.field_22763 = false;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(String.format("Failed to save new Value for Field %s", this.field.getName()));
        }
    }

    protected T getFieldValue() {
        try {
            return (T)this.field.get(null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(String.format("Failed to get Value for Field '%s'", this.field.getName()));
        }
    }
}

