/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resourceconfigapi.client.gui.widget.value_list.entries;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.xstopho.resourceconfigapi.client.gui.screen.ResourceConfigScreen;
import net.xstopho.resourceconfigapi.client.gui.widget.value_list.base.ButtonValueEntry;
import net.xstopho.resourceconfigapi.client.util.GuiUtils;

public class EnumValueEntry<T extends Enum<T>>
extends ButtonValueEntry<T> {
    private final Class<T> clazz;
    private final List<T> enumValues;

    public EnumValueEntry(ResourceConfigScreen screen, String modId, String fileName, String translationKey, Field field, Object defaultValue) {
        super(screen, modId, fileName, translationKey, field, defaultValue);
        if (!field.getType().isEnum()) {
            throw new IllegalArgumentException("Field '" + field.getName() + "' isn't a Enum Value!");
        }
        this.clazz = field.getType();
        this.enumValues = Arrays.stream((Enum[])this.clazz.getEnumConstants()).toList();
        this.valueButton = Button.builder((Component)Component.literal((String)((Enum)this.getFieldValue()).toString()), this::nextEnum).tooltip(GuiUtils.hasTranslation(this.tooltip) ? Tooltip.create((Component)this.tooltip) : null).bounds(0, 0, this.getWidgetWidth(), 20).build();
        this.children.add(this.valueButton);
    }

    @Override
    public T getValue() {
        return Enum.valueOf(this.clazz, this.valueButton.getMessage().getString());
    }

    @Override
    public void undoChanges() {
        this.valueButton.setMessage((Component)Component.literal((String)((Enum)this.getFieldValue()).toString()));
        this.changeUndoState(false);
    }

    @Override
    public void resetValues() {
        this.valueButton.setMessage((Component)Component.literal((String)this.defaultValue.toString()));
        this.changeUndoState(!Objects.equals(this.getValue(), this.getFieldValue()));
        super.resetValues();
    }

    private void nextEnum(Button button) {
        int index = this.enumValues.indexOf(this.getValue());
        index = index < this.enumValues.size() - 1 ? ++index : 0;
        button.setMessage((Component)Component.literal((String)((Enum)this.enumValues.get(index)).toString()));
        super.undoChanges();
    }
}

