/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resourceconfigapi.handler;

import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.xstopho.resourceconfigapi.api.ConfigRegistry;
import net.xstopho.resourceconfigapi.client.gui.screen.ResourceConfigScreen;
import net.xstopho.resourceconfigapi.config.ModConfig;

@EventBusSubscriber(modid="resourceconfigapi", value={Dist.CLIENT})
public class ModClientHandler {
    @SubscribeEvent
    public static void registerModConfigScreens(FMLClientSetupEvent event) {
        for (Map.Entry<ResourceLocation, ModConfig> entry : ConfigRegistry.getConfigEntries()) {
            Optional container = ModList.get().getModContainerById(entry.getKey().getNamespace());
            container.ifPresent(modContainer -> {
                ModLoadingContext.get().setActiveContainer(modContainer);
                ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, () -> (modContainer1, screen) -> new ResourceConfigScreen(screen, modContainer1.getModId()));
            });
        }
    }
}

