/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resourceconfigapi.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.xstopho.resourceconfigapi.ConfigConstants;
import net.xstopho.resourceconfigapi.annotations.Config;
import net.xstopho.resourceconfigapi.annotations.ConfigEntry;
import net.xstopho.resourceconfigapi.annotations.RangedEntry;
import net.xstopho.resourceconfigapi.api.ConfigType;
import net.xstopho.resourceconfigapi.platform.PlatformHelper;
import net.xstopho.resourceconfigapi.util.ConfigUtils;
import org.apache.commons.io.FileUtils;

public class ModConfig {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final boolean isServer = PlatformHelper.INSTANCE.isServer();
    public final ConfigType configType;
    private final File configFile;
    public final String modId;
    private final Map<Field, Object> defaultValueMap;
    public final Class<?> clazz;

    public ModConfig(Class<?> clazz, ConfigType configType, String modId) {
        this.configType = configType;
        this.clazz = clazz;
        this.modId = modId;
        Path configPath = PlatformHelper.INSTANCE.isServer() && configType.equals((Object)ConfigType.SERVER) ? PlatformHelper.INSTANCE.getServerConfigDir() : PlatformHelper.INSTANCE.getConfigDir();
        this.configFile = new File(String.format("%s/%s/%s/%s.json", configPath, modId, configType.name().toLowerCase(), clazz.getAnnotation(Config.class).fileName()));
        this.defaultValueMap = this.createDefaultValueMap();
        this.setup();
    }

    private void setup() {
        this.fromJson(this.readConfig());
        if (this.isServer && this.configType.equals((Object)ConfigType.CLIENT)) {
            this.skipConfig();
        }
        if (!this.isServer && this.configType.equals((Object)ConfigType.SERVER)) {
            this.skipConfig();
        }
        this.writeConfig(this.toJson());
    }

    private void skipConfig() {
        ConfigConstants.LOG.info("Config '{}' from type '{}' was skipped.", (Object)this.configFile.getName(), (Object)this.configType);
    }

    public JsonObject toJson() {
        JsonObject config = new JsonObject();
        for (Map.Entry<Field, ConfigEntry> entry : this.getConfigEntries().entrySet()) {
            Object obj;
            String category;
            ConfigEntry annotation = entry.getValue();
            Field field = entry.getKey();
            String string = category = ConfigUtils.isNotEmpty(annotation.category()) ? annotation.category() : null;
            if (ConfigUtils.unsupportedDatatype(field)) {
                if (!PlatformHelper.INSTANCE.isDevEnv()) continue;
                ConfigConstants.LOG.error("Field '{}' is an unsupported Datatype and was skipped. This message will be silent outside the Dev Environment, so make sure you resolve all messages!", (Object)field.getName());
                continue;
            }
            JsonObject jsonObject = null;
            if (category != null && config.has(category)) {
                jsonObject = config.getAsJsonObject(category);
            } else if (category != null) {
                jsonObject = new JsonObject();
            }
            String value = field.getName();
            try {
                obj = field.get(null);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to access field: " + value, e);
            }
            JsonElement jsonElement = gson.toJsonTree(obj);
            if (jsonObject != null) {
                jsonObject.add(value, jsonElement);
                config.add(category, (JsonElement)jsonObject);
                continue;
            }
            config.add(value, jsonElement);
        }
        return config;
    }

    public void fromJson(JsonObject config) {
        for (Map.Entry<Field, ConfigEntry> entry : this.getConfigEntries().entrySet()) {
            JsonElement jsonElement;
            ConfigEntry annotation = entry.getValue();
            Field field = entry.getKey();
            String category = ConfigUtils.isNotEmpty(annotation.category()) ? annotation.category() : null;
            JsonObject jsonObject = null;
            if (category != null && config.has(category)) {
                jsonObject = config.getAsJsonObject(category);
            }
            String value = field.getName();
            JsonElement jsonElement2 = jsonElement = jsonObject != null ? jsonObject.get(value) : config.get(value);
            if (jsonElement == null) {
                if (!PlatformHelper.INSTANCE.isDevEnv()) continue;
                ConfigConstants.LOG.error("Failed to set Value '{}'! Seems to be a new or unsupported Value. This message will be silent outside the Dev Environment, so make sure you resolve all messages!", (Object)value);
                continue;
            }
            try {
                Object obj = this.readValue(jsonElement, field);
                field.set(field, obj);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to set Value for: " + value, e);
            }
        }
    }

    private Object readValue(JsonElement jsonElement, Field field) throws IllegalAccessException {
        Object obj = null;
        try {
            obj = gson.fromJson(jsonElement, field.getType());
        }
        catch (JsonSyntaxException | IllegalStateException e) {
            ConfigConstants.LOG.error("Failed to read value '{}', value is set to its default!", (Object)field.getName());
        }
        if (field.isAnnotationPresent(RangedEntry.class) && field.getType().isPrimitive()) {
            if (field.getType() == Character.TYPE || field.getType() == Character.class) {
                ConfigConstants.LOG.error("Character with RangedEntry annotation found, this will be ignored");
            } else {
                RangedEntry annotation = field.getAnnotation(RangedEntry.class);
                Number number = (Number)obj;
                if (number != null && this.outOfRange(number, annotation)) {
                    ConfigConstants.LOG.error("Value {} is out of Range, using default Value!", (Object)field.getName());
                    obj = field.get(null);
                }
            }
        }
        return obj != null ? obj : field.get(null);
    }

    public JsonObject readConfig() {
        JsonObject jsonObject;
        if (!this.configFile.exists()) {
            return this.toJson();
        }
        FileReader reader = new FileReader(this.configFile);
        try {
            jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to parse config file: " + this.configFile.getName(), e);
            }
        }
        reader.close();
        return jsonObject;
    }

    public void writeConfig(JsonObject config) {
        this.configFile.getParentFile().mkdirs();
        try {
            FileUtils.write((File)this.configFile, (CharSequence)gson.toJson((JsonElement)config), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write config file: " + this.configFile.getName(), e);
        }
    }

    private Map<Field, ConfigEntry> getConfigEntries() {
        HashMap<Field, ConfigEntry> entries = new HashMap<Field, ConfigEntry>();
        for (Field field : this.clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(ConfigEntry.class)) {
                ConfigConstants.LOG.error("Field '{}' isn't annotated as a ConfigEntry is this correct?", (Object)field.getName());
                continue;
            }
            if (!Modifier.isStatic(field.getModifiers()) || Modifier.isFinal(field.getModifiers())) {
                throw new RuntimeException(String.format("Field '%s' isn't static or is final, make sure it is only a static field!", field.getName()));
            }
            ConfigEntry annotation = field.getAnnotation(ConfigEntry.class);
            entries.put(field, annotation);
        }
        return entries;
    }

    private Map<Field, Object> createDefaultValueMap() {
        HashMap<Field, Object> defaultValues = new HashMap<Field, Object>();
        for (Field field : this.clazz.getDeclaredFields()) {
            try {
                defaultValues.put(field, field.get(null));
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Error creating default values map!", e);
            }
        }
        return defaultValues;
    }

    public Object getDefaultValue(Field field) {
        if (this.defaultValueMap != null) {
            return this.defaultValueMap.get(field);
        }
        throw new IllegalStateException("Can't receive default Value for field: " + field.getName());
    }

    public void save() {
        JsonObject config = this.toJson();
        this.writeConfig(config);
    }

    private boolean outOfRange(Number number, RangedEntry anno) {
        return number.doubleValue() > anno.maxValue() || number.doubleValue() < anno.minValue();
    }
}

