/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resourceconfigapi.client.gui.widget.value_list.entries;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_4185;
import net.minecraft.class_7919;
import net.xstopho.resourceconfigapi.client.gui.screen.ResourceConfigScreen;
import net.xstopho.resourceconfigapi.client.gui.widget.value_list.base.ButtonValueEntry;
import net.xstopho.resourceconfigapi.client.util.GuiUtils;

public class EnumValueEntry<T extends Enum<T>>
extends ButtonValueEntry<T> {
    private final Class<T> clazz;
    private final List<T> enumValues;

    public EnumValueEntry(ResourceConfigScreen screen, String modId, String fileName, String translationKey, Field field, Object defaultValue) {
        super(screen, modId, fileName, translationKey, field, defaultValue);
        if (!field.getType().isEnum()) {
            throw new IllegalArgumentException("Field '" + field.getName() + "' isn't a Enum Value!");
        }
        this.clazz = field.getType();
        this.enumValues = Arrays.stream((Enum[])this.clazz.getEnumConstants()).toList();
        this.valueButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)((Enum)this.getFieldValue()).toString()), this::nextEnum).method_46436(GuiUtils.hasTranslation(this.tooltip) ? class_7919.method_47407((class_2561)this.tooltip) : null).method_46434(0, 0, this.getWidgetWidth(), 20).method_46431();
        this.children.add(this.valueButton);
    }

    @Override
    public T getValue() {
        return Enum.valueOf(this.clazz, this.valueButton.method_25369().getString());
    }

    @Override
    public void undoChanges() {
        this.valueButton.method_25355((class_2561)class_2561.method_43470((String)((Enum)this.getFieldValue()).toString()));
        this.changeUndoState(false);
    }

    @Override
    public void resetValues() {
        this.valueButton.method_25355((class_2561)class_2561.method_43470((String)this.defaultValue.toString()));
        this.changeUndoState(!Objects.equals(this.getValue(), this.getFieldValue()));
        super.resetValues();
    }

    private void nextEnum(class_4185 button) {
        int index = this.enumValues.indexOf(this.getValue());
        index = index < this.enumValues.size() - 1 ? ++index : 0;
        button.method_25355((class_2561)class_2561.method_43470((String)((Enum)this.enumValues.get(index)).toString()));
        super.undoChanges();
    }
}

