/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resourceconfigapi.client.util;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.resources.language.ClientLanguage;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.xstopho.resourceconfigapi.ConfigConstants;
import net.xstopho.resourceconfigapi.annotations.ConfigEntry;
import net.xstopho.resourceconfigapi.client.ClientConstants;
import net.xstopho.resourceconfigapi.client.gui.tooltip.EntryLabelTooltipPosition;

public class GuiUtils {
    private static final ResourceLocation directImpact = ConfigConstants.of("textures/gui/sprites/icon/direct_impact.png");
    private static final ResourceLocation worldRestart = ConfigConstants.of("textures/gui/sprites/icon/world_restart.png");
    private static final ResourceLocation gameRestart = ConfigConstants.of("textures/gui/sprites/icon/game_restart.png");

    public static Font getFont() {
        return Minecraft.getInstance().font;
    }

    public static void renderIcon(GuiGraphics guiGraphics, Field field, int xPos, int yPos, int mouseX, int mouseY) {
        ConfigEntry config = field.getAnnotation(ConfigEntry.class);
        if (!config.needsGameRestart() && !config.needsWorldRestart()) {
            GuiUtils.renderIcon(guiGraphics, directImpact, ClientConstants.DIRECT_IMPACT_TOOLTIP, xPos, yPos, mouseX, mouseY);
        }
        if (config.needsGameRestart()) {
            GuiUtils.renderIcon(guiGraphics, gameRestart, ClientConstants.NEEDS_GAME_RESTART_TOOLTIP, xPos, yPos, mouseX, mouseY);
        }
        if (config.needsWorldRestart()) {
            GuiUtils.renderIcon(guiGraphics, worldRestart, ClientConstants.NEEDS_WORLD_RESTART_TOOLTIP, xPos, yPos, mouseX, mouseY);
        }
    }

    public static void renderIcon(GuiGraphics guiGraphics, ResourceLocation texture, Component tooltip, int xPos, int yPos, int mouseX, int mouseY) {
        guiGraphics.blit(texture, xPos, yPos, 0.0f, 0.0f, 11, 11, 11, 11);
        if (GuiUtils.inBounds(xPos, yPos, xPos + 11, yPos + 11, mouseX, mouseY)) {
            guiGraphics.renderTooltip(GuiUtils.getFont(), GuiUtils.splitTooltip(tooltip, 170), (ClientTooltipPositioner)EntryLabelTooltipPosition.INSTANCE, mouseX, mouseY);
        }
    }

    public static void drawStringWithTooltip(GuiGraphics guiGraphics, Component title, Component tooltip, int xPos, int yPos, int mouseX, int mouseY) {
        if (title != null) {
            guiGraphics.drawString(GuiUtils.getFont(), title, xPos, yPos, -1, false);
            if (tooltip != null) {
                int xMax = xPos + GuiUtils.getFont().width(title.getString());
                Objects.requireNonNull(GuiUtils.getFont());
                int yMax = yPos + 9;
                if (GuiUtils.hasTranslation(tooltip) && GuiUtils.inBounds(xPos, yPos, xMax, yMax, mouseX, mouseY)) {
                    guiGraphics.renderTooltip(GuiUtils.getFont(), GuiUtils.splitTooltip(tooltip, 170), (ClientTooltipPositioner)EntryLabelTooltipPosition.INSTANCE, mouseX, mouseY);
                }
            }
        }
    }

    public static List<FormattedCharSequence> splitTooltip(Component component, int width) {
        return GuiUtils.getFont().split((FormattedText)component, width);
    }

    public static boolean inBounds(int xPos, int yPos, int xMax, int yMax, int mouseX, int mouseY) {
        return xPos <= mouseX && xMax >= mouseX && yPos <= mouseY && yMax >= mouseY;
    }

    public static boolean hasTranslation(Component component) {
        String key = GuiUtils.getComponentKey(component);
        String translated = ClientLanguage.getInstance().getOrDefault(key);
        return !translated.equals(key);
    }

    private static String getComponentKey(Component component) {
        String fullKey = component.toString();
        return fullKey.substring(17, fullKey.length() - 11);
    }
}

