/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resourceconfigapi.client.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.xstopho.resourceconfigapi.ConfigConstants;
import net.xstopho.resourceconfigapi.client.util.GuiUtils;
import net.xstopho.resourceconfigapi.platform.PlatformHelper;

public class ComponentUtils {
    public static final LinkedList<Component> NEEDED_TRANSLATION = new LinkedList();
    public static final LinkedList<Component> OPTIONAL_TRANSLATION = new LinkedList();

    public static Component title(String key) {
        return ComponentUtils.build(String.format("%s.%s", key, "title"));
    }

    public static Component label(String key) {
        return ComponentUtils.build(String.format("%s.%s", key, "label"));
    }

    public static Component tooltip(String key) {
        return ComponentUtils.build(String.format("%s.%s", key, "tooltip"));
    }

    public static Component modConfig(String modId, String key) {
        return ComponentUtils.build(String.format("%s.%s", modId, key));
    }

    public static Component modLabel(String modId, String fileName, String key) {
        return ComponentUtils.label(String.format("%s.%s.%s", modId, fileName, key));
    }

    public static Component modTooltip(String modId, String fileName, String key) {
        return ComponentUtils.tooltip(String.format("%s.%s.%s", modId, fileName, key));
    }

    private static Component build(String key) {
        MutableComponent component = Component.translatable((String)String.format("%s.%s", "config", ComponentUtils.convert(key)));
        if (GuiUtils.hasTranslation((Component)component)) {
            return component;
        }
        if (component.getString().contains("tooltip")) {
            ComponentUtils.addIfAbsent(OPTIONAL_TRANSLATION, (Component)component);
        } else {
            ComponentUtils.addIfAbsent(NEEDED_TRANSLATION, (Component)component);
        }
        return component;
    }

    private static String convert(String key) {
        return key.toLowerCase().replace(" ", "_");
    }

    public static void loggMissingTranslations(String modId) {
        if (!PlatformHelper.INSTANCE.isDevEnv()) {
            return;
        }
        ComponentUtils.logMissingTranslations(modId, NEEDED_TRANSLATION, "The following keys are necessary for the User to properly edit your Configs!");
        ComponentUtils.logMissingTranslations(modId, OPTIONAL_TRANSLATION, "The following keys are optional, they add a Tooltip to the Label, this might help to explain some Options to the User.");
    }

    private static void logMissingTranslations(String modId, LinkedList<Component> translations, String message) {
        if (!translations.isEmpty()) {
            ConfigConstants.LOG.info("\nYour Config/s for '{}' contains untranslated keys.\n{}\n\n{}", new Object[]{modId, message, ComponentUtils.buildLog(modId, translations)});
        }
    }

    private static String buildLog(String modId, LinkedList<Component> components) {
        List<Component> modComponents = ComponentUtils.collectModComponents(modId, components);
        StringBuilder builder = new StringBuilder();
        Iterator<Component> it = modComponents.iterator();
        while (it.hasNext()) {
            Component comp = it.next();
            if (comp.getString().contains(modId)) {
                builder.append("\"").append(comp.getString()).append("\": \"\"");
            }
            if (it.hasNext()) {
                builder.append(",\n");
                continue;
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    private static List<Component> collectModComponents(String modId, List<Component> list) {
        LinkedList<Component> modComponents = new LinkedList<Component>();
        for (Component comp : list) {
            if (!comp.getString().contains(modId)) continue;
            modComponents.add(comp);
        }
        return modComponents;
    }

    private static void addIfAbsent(List<Component> list, Component component) {
        if (list.contains(component)) {
            return;
        }
        list.add(component);
    }
}

