/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resourceconfigapi.client.util;

import java.lang.reflect.Field;
import net.xstopho.resourceconfigapi.client.gui.widget.value_list.base.BaseEntry;
import net.xstopho.resourceconfigapi.client.gui.widget.value_list.entries.BooleanValueEntry;
import net.xstopho.resourceconfigapi.client.gui.widget.value_list.entries.ByteValueEntry;
import net.xstopho.resourceconfigapi.client.gui.widget.value_list.entries.DoubleValueEntry;
import net.xstopho.resourceconfigapi.client.gui.widget.value_list.entries.EnumValueEntry;
import net.xstopho.resourceconfigapi.client.gui.widget.value_list.entries.FloatValueEntry;
import net.xstopho.resourceconfigapi.client.gui.widget.value_list.entries.IntegerValueEntry;
import net.xstopho.resourceconfigapi.client.gui.widget.value_list.entries.LongValueEntry;
import net.xstopho.resourceconfigapi.client.gui.widget.value_list.entries.ShortValueEntry;
import net.xstopho.resourceconfigapi.client.gui.widget.value_list.entries.StringValueEntry;

public class ValueEntryCreator {
    public static BaseEntry create(String modId, String fileName, String translation, Field field, Object defaultValue) {
        Class<?> clazz = field.getType();
        return switch (clazz.getSimpleName().toLowerCase()) {
            case "boolean" -> new BooleanValueEntry(modId, fileName, translation, field, defaultValue);
            case "byte" -> new ByteValueEntry(modId, fileName, translation, field, defaultValue);
            case "double" -> new DoubleValueEntry(modId, fileName, translation, field, defaultValue);
            case "float" -> new FloatValueEntry(modId, fileName, translation, field, defaultValue);
            case "int", "integer" -> new IntegerValueEntry(modId, fileName, translation, field, defaultValue);
            case "long" -> new LongValueEntry(modId, fileName, translation, field, defaultValue);
            case "short" -> new ShortValueEntry(modId, fileName, translation, field, defaultValue);
            case "string" -> new StringValueEntry(modId, fileName, translation, field, defaultValue);
            default -> {
                if (clazz.isEnum()) {
                    yield new EnumValueEntry(modId, fileName, translation, field, defaultValue);
                }
                throw new IllegalStateException(String.format("Something went wrong while creating a ValueEntry for Field '%s'!", field.getName()));
            }
        };
    }
}

