/*
 * Decompiled with CFR 0.152.
 */
package wtf.wooly.LoginCooldown.listeners;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import wtf.wooly.LoginCooldown.LoginCooldown;

public class PlayerLoginListener
implements Listener {
    private final Map<String, Queue<Long>> playerMessageTimestamps = new HashMap<String, Queue<Long>>();

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onAsyncPlayerPreLogin(AsyncPlayerPreLoginEvent event) {
        LoginCooldown plugin = LoginCooldown.getPlugin();
        String playerName = event.getName();
        int joinsPer = plugin.getConfig().getInt("joins-per");
        int timeFrame = plugin.getConfig().getInt("time-frame");
        long currentTime = System.currentTimeMillis();
        long timeFrameMillis = (long)timeFrame * 1000L;
        this.playerMessageTimestamps.putIfAbsent(playerName, new LinkedList());
        Queue<Long> timestamps = this.playerMessageTimestamps.get(playerName);
        while (!timestamps.isEmpty() && currentTime - timestamps.peek() > timeFrameMillis) {
            timestamps.poll();
        }
        if (timestamps.size() >= joinsPer) {
            Long earliestTimestamp = timestamps.peek();
            if (earliestTimestamp != null) {
                long timeUntilNextJoin = timeFrameMillis - (currentTime - earliestTimestamp);
                String minutesUntilNextJoin = String.valueOf((timeUntilNextJoin + 59999L) / 60000L);
                event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_OTHER, LoginCooldown.deserialise(plugin.getConfig().getString("blocked-msg").replace("[mins]", minutesUntilNextJoin)));
                plugin.getServer().broadcast(LoginCooldown.deserialise(plugin.getConfig().getString("mod-msg").replace("[username]", playerName)), "logincooldown.notify");
            }
        } else {
            timestamps.add(currentTime);
        }
    }
}

