/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.block;

import baguchi.tofucraft.blockentity.FoodPlateBlockEntity;
import baguchi.tofucraft.registry.TofuBlockEntitys;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.Nullable;

public class FoodPlateBlock
extends BaseEntityBlock {
    public static final MapCodec<FoodPlateBlock> CODEC = FoodPlateBlock.simpleCodec(FoodPlateBlock::new);
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    protected static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)14.0);
    public static final ResourceLocation CONTENTS = ResourceLocation.withDefaultNamespace((String)"contents");

    public FoodPlateBlock(BlockBehaviour.Properties p_49224_) {
        super(p_49224_);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void animateTick(BlockState p_220697_, Level level, BlockPos blockPos, RandomSource p_220700_) {
        FoodPlateBlockEntity foodPlate;
        BlockEntity tileEntity = level.getBlockEntity(blockPos);
        if (tileEntity instanceof FoodPlateBlockEntity && (foodPlate = (FoodPlateBlockEntity)tileEntity).isFire()) {
            FoodPlateBlock.addParticlesAndSound(level, new Vec3(0.5, 0.5, 0.5).add((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ()), p_220700_);
        }
    }

    private static void addParticlesAndSound(Level p_220688_, Vec3 p_220689_, RandomSource p_220690_) {
        float f = p_220690_.nextFloat();
        if (f < 0.3f) {
            p_220688_.addParticle((ParticleOptions)ParticleTypes.SMOKE, p_220689_.x, p_220689_.y, p_220689_.z, 0.0, 0.0, 0.0);
            if (f < 0.17f) {
                p_220688_.playLocalSound(p_220689_.x + 0.5, p_220689_.y + 0.5, p_220689_.z + 0.5, SoundEvents.CANDLE_AMBIENT, SoundSource.BLOCKS, 1.0f + p_220690_.nextFloat(), p_220690_.nextFloat() * 0.7f + 0.3f, false);
            }
        }
        p_220688_.addParticle((ParticleOptions)ParticleTypes.SMALL_FLAME, p_220689_.x, p_220689_.y, p_220689_.z, 0.0, 0.0, 0.0);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected InteractionResult useItemOn(ItemStack itemStack, BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity tileEntity = level.getBlockEntity(blockPos);
        if (tileEntity instanceof FoodPlateBlockEntity) {
            FoodPlateBlockEntity plateBlockEntity = (FoodPlateBlockEntity)tileEntity;
            ItemStack heldStack = player.getItemInHand(hand);
            if (plateBlockEntity.isEmpty()) {
                if (heldStack.isEmpty()) {
                    return InteractionResult.TRY_WITH_EMPTY_HAND;
                }
                if (plateBlockEntity.addItem(player.getAbilities().instabuild ? heldStack.copy() : heldStack)) {
                    level.playSound(null, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), SoundEvents.WOOD_PLACE, SoundSource.BLOCKS, 1.0f, 0.8f);
                    return InteractionResult.SUCCESS;
                }
            } else {
                if (!heldStack.isEmpty()) {
                    if ((heldStack.is(Items.FLINT_AND_STEEL) || heldStack.is(Items.FIRE_CHARGE)) && plateBlockEntity.getStoredItem().is(ItemTags.CANDLES) && !plateBlockEntity.isFire()) {
                        level.playSound((Entity)player, blockPos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS);
                        plateBlockEntity.setFire(true);
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.CONSUME;
                }
                if (hand.equals((Object)InteractionHand.MAIN_HAND)) {
                    if (!player.isCreative()) {
                        if (!player.getInventory().add(plateBlockEntity.removeItem())) {
                            Containers.dropItemStack((Level)level, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), (ItemStack)plateBlockEntity.removeItem());
                        }
                    } else {
                        plateBlockEntity.removeItem();
                    }
                    level.playSound(null, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), SoundEvents.WOOD_HIT, SoundSource.BLOCKS, 0.25f, 0.5f);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.TRY_WITH_EMPTY_HAND;
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ItemAbility itemAbility, boolean simulate) {
        return super.getToolModifiedState(state, context, itemAbility, simulate);
    }

    public void affectNeighborsAfterRemoval(BlockState state, ServerLevel worldIn, BlockPos pos, boolean isMoving) {
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        if (tileEntity instanceof FoodPlateBlockEntity) {
            worldIn.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.affectNeighborsAfterRemoval(state, worldIn, pos, isMoving);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState blockState, Level worldIn, BlockPos pos, Direction p_435855_) {
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        if (tileEntity instanceof FoodPlateBlockEntity) {
            return !((FoodPlateBlockEntity)tileEntity).isEmpty() ? 15 : 0;
        }
        return 0;
    }

    @javax.annotation.Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)TofuBlockEntitys.FOODPLATE.get()).create(pos, state);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluid = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected BlockState updateShape(BlockState state, LevelReader worldIn, ScheduledTickAccess p_374457_, BlockPos currentPos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource randomSource) {
        return facing == Direction.DOWN && !state.canSurvive(worldIn, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, worldIn, p_374457_, currentPos, facing, facingPos, facingState, randomSource);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState rotate(BlockState pState, Rotation pRot) {
        return (BlockState)pState.setValue(FACING, (Comparable)pRot.rotate((Direction)pState.getValue(FACING)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue(FACING)));
    }

    public BlockState playerWillDestroy(Level p_56212_, BlockPos p_56213_, BlockState p_56214_, Player p_56215_) {
        BlockEntity blockentity = p_56212_.getBlockEntity(p_56213_);
        if (blockentity instanceof FoodPlateBlockEntity) {
            FoodPlateBlockEntity foodPlateBlockEntity = (FoodPlateBlockEntity)blockentity;
            if (!p_56212_.isClientSide() && p_56215_.preventsBlockDrops() && !foodPlateBlockEntity.isEmpty()) {
                ItemStack itemstack = this.asItem().getDefaultInstance();
                itemstack.applyComponents(blockentity.collectComponents());
                ItemEntity itementity = new ItemEntity(p_56212_, (double)p_56213_.getX() + 0.5, (double)p_56213_.getY() + 0.5, (double)p_56213_.getZ() + 0.5, itemstack);
                itementity.setDefaultPickUpDelay();
                p_56212_.addFreshEntity((Entity)itementity);
            }
        }
        return super.playerWillDestroy(p_56212_, p_56213_, p_56214_, p_56215_);
    }

    protected List<ItemStack> getDrops(BlockState p_287632_, LootParams.Builder p_287691_) {
        BlockEntity blockentity = (BlockEntity)p_287691_.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (blockentity instanceof FoodPlateBlockEntity) {
            FoodPlateBlockEntity foodPlateBlockEntity = (FoodPlateBlockEntity)blockentity;
            p_287691_ = p_287691_.withDynamicDrop(CONTENTS, p_56219_ -> {
                for (int i = 0; i < foodPlateBlockEntity.getContainerSize(); ++i) {
                    p_56219_.accept(foodPlateBlockEntity.getItem(i));
                }
            });
        }
        return super.getDrops(p_287632_, p_287691_);
    }
}

