/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.block;

import baguchi.tofucraft.datamap.TofuHarden;
import baguchi.tofucraft.registry.TofuDataMaps;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;

public class TofuDetectorBlock
extends DirectionalBlock {
    public static final MapCodec<TofuDetectorBlock> CODEC = TofuDetectorBlock.simpleCodec(TofuDetectorBlock::new);
    public static final IntegerProperty POWER = BlockStateProperties.POWER;

    public TofuDetectorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.SOUTH)).setValue((Property)POWER, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<? extends DirectionalBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_55125_) {
        p_55125_.add(new Property[]{FACING, POWER});
    }

    public BlockState rotate(BlockState p_55115_, Rotation p_55116_) {
        return (BlockState)p_55115_.setValue((Property)FACING, (Comparable)p_55116_.rotate((Direction)p_55115_.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState p_55112_, Mirror p_55113_) {
        return p_55112_.rotate(p_55113_.getRotation((Direction)p_55112_.getValue((Property)FACING)));
    }

    public void tick(BlockState p_221840_, ServerLevel p_221841_, BlockPos p_221842_, RandomSource p_221843_) {
        Direction direction = (Direction)p_221840_.getValue((Property)FACING);
        BlockPos blockpos = p_221842_.relative(direction);
        this.updateSignalStrength(p_221840_, p_221841_.getBlockState(blockpos), (Level)p_221841_, p_221842_);
    }

    protected BlockState updateShape(BlockState p_60541_, LevelReader p_374332_, ScheduledTickAccess p_374457_, BlockPos p_60545_, Direction p_60542_, BlockPos p_60546_, BlockState p_60543_, RandomSource p_374120_) {
        if (p_60541_.getValue((Property)FACING) == p_60542_ && !p_374457_.getBlockTicks().hasScheduledTick(p_60545_, (Object)this)) {
            p_374457_.scheduleTick(p_60545_, (Block)this, 2);
        }
        return super.updateShape(p_60541_, p_374332_, p_374457_, p_60545_, p_60542_, p_60546_, p_60543_, p_374120_);
    }

    public boolean isSignalSource(BlockState p_55138_) {
        return true;
    }

    protected int getDirectSignal(BlockState p_55127_, BlockGetter p_55128_, BlockPos p_55129_, Direction p_55130_) {
        return p_55127_.getSignal(p_55128_, p_55129_, p_55130_);
    }

    protected int getSignal(BlockState p_52386_, BlockGetter p_52387_, BlockPos p_52388_, Direction p_52389_) {
        return p_52386_.getValue((Property)FACING) == p_52389_ ? (Integer)p_52386_.getValue((Property)POWER) : 0;
    }

    private void updateSignalStrength(BlockState p_52411_, BlockState faced, Level p_52412_, BlockPos p_52413_) {
        TofuHarden harden = TofuDataMaps.HARDEN_DATA.get(faced.getBlock());
        int i = harden != null ? harden.level() : 0;
        i = Mth.clamp((int)i, (int)0, (int)15);
        if ((Integer)p_52411_.getValue((Property)POWER) != i) {
            p_52412_.setBlock(p_52413_, (BlockState)p_52411_.setValue((Property)POWER, (Comparable)Integer.valueOf(i)), 18);
            Direction direction = (Direction)p_52411_.getValue((Property)FACING);
            BlockPos blockpos = p_52413_.relative(direction.getOpposite());
            Orientation orientation = ExperimentalRedstoneUtils.initialOrientation((Level)p_52412_, (Direction)direction.getOpposite(), null);
            p_52412_.neighborChanged(blockpos, (Block)this, orientation);
            p_52412_.updateNeighborsAtExceptFromFacing(blockpos, (Block)this, direction, orientation);
        }
    }

    protected void updateNeighborsInFront(Level p_55089_, BlockPos p_55090_, BlockState p_55091_) {
        Direction direction = (Direction)p_55091_.getValue((Property)FACING);
        BlockPos blockpos = p_55090_.relative(direction.getOpposite());
        Orientation orientation = ExperimentalRedstoneUtils.initialOrientation((Level)p_55089_, (Direction)direction.getOpposite(), null);
        p_55089_.neighborChanged(blockpos, (Block)this, orientation);
        p_55089_.updateNeighborsAtExceptFromFacing(blockpos, (Block)this, direction, orientation);
    }

    protected void onPlace(BlockState p_55132_, Level p_55133_, BlockPos p_55134_, BlockState p_55135_, boolean p_55136_) {
        if (!p_55132_.is(p_55135_.getBlock()) && !p_55133_.isClientSide()) {
            Direction direction = (Direction)p_55132_.getValue((Property)FACING);
            BlockPos blockpos = p_55134_.relative(direction);
            this.updateSignalStrength(p_55132_, p_55133_.getBlockState(blockpos), p_55133_, p_55134_);
        }
    }

    protected void affectNeighborsAfterRemoval(BlockState p_393998_, ServerLevel p_394664_, BlockPos p_394449_, boolean p_394257_) {
        if ((Integer)p_393998_.getValue((Property)POWER) > 0 && !p_394664_.getBlockTicks().hasScheduledTick(p_394449_, (Object)this)) {
            this.updateNeighborsInFront((Level)p_394664_, p_394449_, (BlockState)p_393998_.setValue((Property)POWER, (Comparable)Integer.valueOf(0)));
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext p_55087_) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)p_55087_.getNearestLookingDirection().getOpposite().getOpposite());
    }
}

