/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.blockentity;

import baguchi.tofucraft.blockentity.SyncedBlockEntity;
import baguchi.tofucraft.registry.TofuBlockEntitys;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class FoodPlateBlockEntity
extends SyncedBlockEntity
implements Container {
    protected NonNullList<ItemStack> items = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    @Nullable
    private Component name;
    private boolean fire;

    public FoodPlateBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TofuBlockEntitys.FOODPLATE.get(), pos, state);
    }

    public void loadAdditional(ValueInput compound) {
        super.loadAdditional(compound);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((ValueInput)compound, this.items);
        this.fire = compound.getBooleanOr("Fire", false);
        this.name = FoodPlateBlockEntity.parseCustomNameSafe((ValueInput)compound, (String)"CustomName");
    }

    public void saveAdditional(ValueOutput compound) {
        super.saveAdditional(compound);
        ContainerHelper.saveAllItems((ValueOutput)compound, this.items);
        compound.putBoolean("Fire", this.fire);
        compound.storeNullable("CustomName", ComponentSerialization.CODEC, (Object)this.name);
    }

    public boolean addItem(ItemStack itemStack) {
        if (this.isEmpty() && !itemStack.isEmpty()) {
            this.items.set(0, (Object)itemStack.split(1));
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    public boolean addAllItem(ItemStack itemStack) {
        if (this.isEmpty() && !itemStack.isEmpty()) {
            this.items.set(0, (Object)itemStack.split(64));
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    public ItemStack removeItem() {
        if (!this.isEmpty()) {
            ItemStack item = this.getStoredItem().split(1);
            this.inventoryChanged();
            if (this.isFire()) {
                this.setFire(false);
            }
            return item;
        }
        return ItemStack.EMPTY;
    }

    public ItemStack getStoredItem() {
        if (this.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return (ItemStack)this.items.get(0);
    }

    public int getContainerSize() {
        return 1;
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int i) {
        return (ItemStack)this.items.get(i);
    }

    public ItemStack removeItem(int p_332707_, int p_332672_) {
        ItemStack itemstack = ContainerHelper.removeItem(this.items, (int)p_332707_, (int)p_332672_);
        if (!itemstack.isEmpty()) {
            this.setChanged();
        }
        return itemstack;
    }

    public ItemStack removeItemNoUpdate(int p_332812_) {
        return ContainerHelper.takeItem(this.items, (int)p_332812_);
    }

    public void setItem(int i, ItemStack itemStack) {
        this.items.set(i, (Object)itemStack);
        this.setChanged();
    }

    public boolean stillValid(Player p_332791_) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)p_332791_);
    }

    public void setFire(boolean fire) {
        this.fire = fire;
        this.inventoryChanged();
    }

    public boolean isFire() {
        return this.fire;
    }

    public void clearContent() {
        this.items.clear();
    }

    public void preRemoveSideEffects(BlockPos p_397016_, BlockState p_397217_) {
    }

    protected void applyImplicitComponents(DataComponentGetter p_397486_) {
        super.applyImplicitComponents(p_397486_);
        this.name = (Component)p_397486_.get(DataComponents.CUSTOM_NAME);
        ((ItemContainerContents)p_397486_.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).copyInto(this.items);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder p_338252_) {
        super.collectImplicitComponents(p_338252_);
        p_338252_.set(DataComponents.CUSTOM_NAME, (Object)this.name);
        p_338252_.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(this.items));
    }

    public void removeComponentsFromTag(ValueOutput p_421741_) {
        p_421741_.discard("CustomName");
        p_421741_.discard("Items");
    }
}

