/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.blockentity.tfenergy;

import baguchi.tofucraft.block.tfenergy.TFCraftingTableBlock;
import baguchi.tofucraft.blockentity.tfenergy.base.WorkerBaseBlockEntity;
import baguchi.tofucraft.inventory.TFCraftingTableMenu;
import baguchi.tofucraft.recipe.TFCraftingRecipe;
import baguchi.tofucraft.registry.TofuBlockEntitys;
import baguchi.tofucraft.registry.TofuRecipes;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.recipebook.PlaceRecipeHelper;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapedCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapelessCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public class TFCraftingTableBlockEntity
extends WorkerBaseBlockEntity
implements WorldlyContainer,
StackedContentsCompatible,
RecipeCraftingHolder,
MenuProvider {
    protected NonNullList<ItemStack> inventory = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
    @Nullable
    protected RecipeDisplay recipeDisplay;
    private int progress = 0;
    private int progressMax = 0;
    private int refreshTime = 0;
    public static final int MAX_CRAFT_TIME = 200;
    private final RecipeManager.CachedCheck<CraftingInput, ? extends TFCraftingRecipe> quickCheck;
    private final RecipeManager.CachedCheck<CraftingInput, ? extends CraftingRecipe> quickNormalCheck;
    private static final int[] SLOTS_FOR_UP = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private static final int[] SLOTS_FOR_DOWN = new int[]{9};
    protected final ContainerData dataAccess = new ContainerData(){

        public int get(int p_221476_1_) {
            switch (p_221476_1_) {
                case 0: {
                    return TFCraftingTableBlockEntity.this.progress;
                }
                case 1: {
                    return TFCraftingTableBlockEntity.this.progressMax;
                }
                case 2: {
                    return TFCraftingTableBlockEntity.this.energy;
                }
                case 3: {
                    return TFCraftingTableBlockEntity.this.energyMax;
                }
            }
            return 0;
        }

        public void set(int p_221477_1_, int p_221477_2_) {
            switch (p_221477_1_) {
                case 0: {
                    TFCraftingTableBlockEntity.this.progress = p_221477_2_;
                    break;
                }
                case 1: {
                    TFCraftingTableBlockEntity.this.progressMax = p_221477_2_;
                    break;
                }
                case 2: {
                    TFCraftingTableBlockEntity.this.energy = p_221477_2_;
                    break;
                }
                case 3: {
                    TFCraftingTableBlockEntity.this.energyMax = p_221477_2_;
                }
            }
        }

        public int getCount() {
            return 4;
        }
    };

    public TFCraftingTableBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)TofuBlockEntitys.TF_CRAFTING_TABLE.get(), p_155229_, p_155230_, 10000);
        this.quickCheck = RecipeManager.createCheck(TofuRecipes.RECIPETYPE_TF_CRAFT.get());
        this.quickNormalCheck = RecipeManager.createCheck((RecipeType)RecipeType.CRAFTING);
    }

    public void setRecipeDisplay(@Nullable RecipeDisplay recipeDisplay) {
        this.recipeDisplay = recipeDisplay;
        this.setChanged();
    }

    @Nullable
    public RecipeDisplay getRecipeDisplay() {
        return this.recipeDisplay;
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, TFCraftingTableBlockEntity tfoven) {
        if (level.isClientSide() || !((Boolean)blockState.getValue((Property)TFCraftingTableBlock.ENABLED)).booleanValue()) {
            return;
        }
        boolean worked = false;
        if (tfoven.getEnergyStored() > 0 && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (tfoven.refreshTime <= 0) {
                ItemStack craftStack;
                Optional optional = tfoven.quickCheck.getRecipeFor((RecipeInput)CraftingInput.of((int)3, (int)3, tfoven.inventory), serverLevel);
                Optional optional2 = tfoven.quickNormalCheck.getRecipeFor((RecipeInput)CraftingInput.of((int)3, (int)3, tfoven.inventory), serverLevel);
                ItemStack tfStack = optional.isEmpty() ? ItemStack.EMPTY : ((TFCraftingRecipe)((RecipeHolder)optional.get()).value()).assemble((RecipeInput)CraftingInput.of((int)3, (int)3, tfoven.inventory), (HolderLookup.Provider)serverLevel.registryAccess());
                ItemStack itemStack = craftStack = optional2.isEmpty() ? ItemStack.EMPTY : ((CraftingRecipe)((RecipeHolder)optional2.get()).value()).assemble((RecipeInput)CraftingInput.of((int)3, (int)3, tfoven.inventory), (HolderLookup.Provider)serverLevel.registryAccess());
                if (optional.isPresent() && tfoven.canProcess(tfStack) && (tfoven.recipeDisplay == null || !((TFCraftingRecipe)((RecipeHolder)optional.get()).value()).display().isEmpty() && ((TFCraftingRecipe)((RecipeHolder)optional.get()).value()).display().contains(tfoven.recipeDisplay))) {
                    tfoven.progressMax = ((TFCraftingRecipe)((RecipeHolder)optional.get()).value()).getNeedTF() / 10;
                    ++tfoven.progress;
                    if (tfoven.progress >= tfoven.progressMax) {
                        tfoven.progress = 0;
                        if (tfoven.craftTF(tfStack, tfoven.inventory)) {
                            tfoven.setRecipeUsed((RecipeHolder)optional.get());
                        }
                    }
                    worked = true;
                    tfoven.drain(10, false);
                    tfoven.setChanged();
                } else if (optional2.isPresent() && tfoven.canProcess(craftStack) && (tfoven.recipeDisplay == null || !((CraftingRecipe)((RecipeHolder)optional2.get()).value()).display().isEmpty() && ((CraftingRecipe)((RecipeHolder)optional2.get()).value()).display().contains(tfoven.recipeDisplay))) {
                    tfoven.progressMax = 10;
                    ++tfoven.progress;
                    if (tfoven.progress >= tfoven.progressMax) {
                        tfoven.progress = 0;
                        if (tfoven.craft(craftStack, tfoven.inventory)) {
                            tfoven.setRecipeUsed((RecipeHolder)optional2.get());
                        }
                    }
                    worked = true;
                    tfoven.drain(10, false);
                    tfoven.setChanged();
                } else {
                    tfoven.progress = 0;
                    tfoven.refreshTime = 10 + tfoven.level.random.nextInt(20);
                    tfoven.setChanged();
                }
            } else {
                tfoven.progress = 0;
                --tfoven.refreshTime;
                tfoven.setChanged();
            }
        }
        if ((Boolean)blockState.getValue((Property)BlockStateProperties.LIT) != worked) {
            level.setBlock(blockPos, (BlockState)blockState.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(worked)), 2);
        }
    }

    private boolean craft(ItemStack result, NonNullList<ItemStack> p_267073_) {
        if (!result.isEmpty()) {
            ItemStack itemstack1 = result.copy();
            ItemStack itemstack2 = (ItemStack)p_267073_.get(9);
            if (itemstack2.isEmpty()) {
                p_267073_.set(9, (Object)itemstack1.copy());
            } else if (itemstack2.is(itemstack1.getItem())) {
                itemstack2.grow(itemstack1.getCount());
            }
            for (int i = 0; i < 9; ++i) {
                ItemStack slotStack = (ItemStack)this.inventory.get(i);
                if (!slotStack.getCraftingRemainder().isEmpty()) {
                    this.ejectIngredientRemainder(slotStack.getCraftingRemainder());
                }
                if (slotStack.isEmpty()) continue;
                slotStack.shrink(1);
            }
            return true;
        }
        return false;
    }

    protected boolean canProcess(ItemStack result) {
        int i = this.getMaxStackSize();
        ItemStack resultStack = result.copy();
        if (resultStack.isEmpty()) {
            return false;
        }
        ItemStack storedMealStack = (ItemStack)this.inventory.get(9);
        if (storedMealStack.isEmpty()) {
            return true;
        }
        if (!ItemStack.isSameItem((ItemStack)storedMealStack, (ItemStack)resultStack)) {
            return false;
        }
        if (storedMealStack.getCount() + resultStack.getCount() <= i && storedMealStack.getCount() + resultStack.getCount() <= storedMealStack.getMaxStackSize()) {
            return true;
        }
        return storedMealStack.getCount() + resultStack.getCount() <= resultStack.getMaxStackSize();
    }

    private boolean craftTF(ItemStack result, NonNullList<ItemStack> p_267073_) {
        if (!result.isEmpty()) {
            ItemStack itemstack1 = result.copy();
            ItemStack itemstack2 = (ItemStack)p_267073_.get(9);
            if (itemstack2.isEmpty()) {
                p_267073_.set(9, (Object)itemstack1.copy());
            } else if (itemstack2.is(itemstack1.getItem())) {
                itemstack2.grow(itemstack1.getCount());
            }
            for (int i = 0; i < 9; ++i) {
                ItemStack slotStack = (ItemStack)this.inventory.get(i);
                if (!slotStack.getCraftingRemainder().isEmpty()) {
                    this.ejectIngredientRemainder(slotStack.getCraftingRemainder());
                }
                if (slotStack.isEmpty()) continue;
                slotStack.shrink(1);
            }
            return true;
        }
        return false;
    }

    protected void ejectIngredientRemainder(ItemStack remainderStack) {
        Direction direction = ((Direction)this.getBlockState().getValue(TFCraftingTableBlock.HORIZONTAL_FACING)).getCounterClockWise();
        double x = (double)this.worldPosition.getX() + 0.5 + (double)direction.getStepX() * 0.25;
        double y = (double)this.worldPosition.getY() + 0.7;
        double z = (double)this.worldPosition.getZ() + 0.5 + (double)direction.getStepZ() * 0.25;
        ItemEntity entity = new ItemEntity(this.level, x, y, z, remainderStack);
        entity.setDeltaMovement((double)((float)direction.getStepX() * 0.08f), 0.25, (double)((float)direction.getStepZ() * 0.08f));
        this.level.addFreshEntity((Entity)entity);
    }

    public int getContainerSize() {
        return 10;
    }

    public ItemStack getItem(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack removeItemNoUpdate(int p_70304_1_) {
        return ContainerHelper.takeItem(this.inventory, (int)p_70304_1_);
    }

    public void setItem(int index, ItemStack stack) {
        this.inventory.set(index, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        this.setChanged();
    }

    public ItemStack removeItem(int p_59613_, int p_59614_) {
        ItemStack itemstack = ContainerHelper.removeItem(this.inventory, (int)p_59613_, (int)p_59614_);
        if (!itemstack.isEmpty()) {
            this.setChanged();
        }
        return itemstack;
    }

    public boolean stillValid(Player p_18946_) {
        if (this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return p_18946_.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public void saveAdditional(ValueOutput cmp) {
        super.saveAdditional(cmp);
        ContainerHelper.saveAllItems((ValueOutput)cmp, this.inventory);
        cmp.putInt("progress", this.progress);
        cmp.putInt("progress_max", this.progressMax);
        cmp.putInt("RefreshTime", this.refreshTime);
        if (this.recipeDisplay != null) {
            cmp.store("saved_recipe_display", RecipeDisplay.CODEC, (Object)this.recipeDisplay);
        }
    }

    @Override
    public void loadAdditional(ValueInput cmp) {
        super.loadAdditional(cmp);
        this.inventory = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        this.progress = cmp.getIntOr("progress", 0);
        this.progressMax = cmp.getIntOr("progress_max", 0);
        this.refreshTime = cmp.getIntOr("RefreshTime", 0);
        this.recipeDisplay = cmp.read("saved_recipe_display", RecipeDisplay.CODEC).orElse(null);
    }

    public int[] getSlotsForFace(Direction p_58363_) {
        if (p_58363_ == Direction.DOWN) {
            return SLOTS_FOR_DOWN;
        }
        return SLOTS_FOR_UP;
    }

    public boolean canPlaceItemThroughFace(int p_58336_, ItemStack p_58337_, @javax.annotation.Nullable Direction p_58338_) {
        return this.canPlaceItem(p_58336_, p_58337_);
    }

    public boolean canTakeItemThroughFace(int p_58392_, ItemStack p_58393_, Direction p_58394_) {
        return true;
    }

    public boolean canPlaceItem(int p_58389_, ItemStack p_58390_) {
        if (p_58389_ == 9) {
            return false;
        }
        return this.recipeDisplay == null || this.resolveWithRecipePlace(p_58389_, p_58390_);
    }

    private boolean smallerStackExistWithGrid(int p_307396_, ItemStack p_307520_, int slot, int width, int height) {
        for (int i = slot + 1; i < 9; ++i) {
            ItemStack itemstack = this.getItem(i);
            if (!itemstack.isEmpty() && (itemstack.getCount() >= p_307396_ || !ItemStack.isSameItemSameComponents((ItemStack)itemstack, (ItemStack)p_307520_))) continue;
            return true;
        }
        return false;
    }

    private boolean smallerStackExist(int p_307396_, ItemStack p_307520_, int slot) {
        for (int i = slot + 1; i < 9; ++i) {
            ItemStack itemstack = this.getItem(i);
            if (!itemstack.isEmpty() && (itemstack.getCount() >= p_307396_ || !ItemStack.isSameItemSameComponents((ItemStack)itemstack, (ItemStack)p_307520_))) continue;
            return true;
        }
        return false;
    }

    protected boolean fillRecipe(int slotIndex, ItemStack slotItem, RecipeDisplay recipeDisplay, ContextMap contextMap) {
        boolean[] flag = new boolean[]{false};
        RecipeDisplay recipeDisplay2 = recipeDisplay;
        Objects.requireNonNull(recipeDisplay2);
        RecipeDisplay recipeDisplay3 = recipeDisplay2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ShapedCraftingRecipeDisplay.class, ShapelessCraftingRecipeDisplay.class}, (Object)recipeDisplay3, n)) {
            case 0: {
                ShapedCraftingRecipeDisplay shapedcraftingrecipedisplay = (ShapedCraftingRecipeDisplay)recipeDisplay3;
                PlaceRecipeHelper.placeRecipe((int)3, (int)3, (int)shapedcraftingrecipedisplay.width(), (int)shapedcraftingrecipedisplay.height(), (Iterable)shapedcraftingrecipedisplay.ingredients(), (p_380786_, p_380787_, p_380788_, p_380789_) -> {
                    List list = p_380786_.resolveForStacks(contextMap);
                    if (!list.isEmpty() && list.stream().anyMatch(stack -> ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)slotItem)) && p_380787_ == slotIndex) {
                        flag[0] = true;
                    }
                });
                break;
            }
            case 1: {
                ShapelessCraftingRecipeDisplay shapelesscraftingrecipedisplay = (ShapelessCraftingRecipeDisplay)recipeDisplay3;
                int i = Math.min(shapelesscraftingrecipedisplay.ingredients().size(), 9);
                for (int j = 0; j < i; ++j) {
                    List list = ((SlotDisplay)shapelesscraftingrecipedisplay.ingredients().get(j)).resolveForStacks(contextMap);
                    if (list.isEmpty() || !list.stream().anyMatch(stack -> ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)slotItem)) || j != slotIndex) continue;
                    flag[0] = true;
                }
                break;
            }
        }
        return flag[0];
    }

    private boolean resolveWithRecipePlace(int slot, ItemStack stack) {
        if (this.level == null || this.recipeDisplay == null) {
            return false;
        }
        ContextMap contextMap = SlotDisplayContext.fromLevel((Level)this.level);
        if (this.fillRecipe(slot, stack, this.recipeDisplay, contextMap)) {
            ItemStack itemstack = (ItemStack)this.inventory.get(slot);
            return itemstack.isEmpty();
        }
        return false;
    }

    public void clearContent() {
        this.inventory.clear();
    }

    public void setRecipeUsed(@javax.annotation.Nullable RecipeHolder<?> p_301245_) {
    }

    @javax.annotation.Nullable
    public RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    public void awardUsedRecipes(Player p_58396_, List<ItemStack> p_282202_) {
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter p_397929_) {
        super.applyImplicitComponents(p_397929_);
        ((ItemContainerContents)p_397929_.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).copyInto(this.getInventory());
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.Builder p_338252_) {
        super.collectImplicitComponents(p_338252_);
        p_338252_.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(this.getInventory()));
    }

    @Override
    public void removeComponentsFromTag(ValueOutput p_331127_) {
        super.removeComponentsFromTag(p_331127_);
        p_331127_.discard("Items");
        p_331127_.discard("progress");
        p_331127_.discard("progress_max");
        p_331127_.discard("RefreshTime");
        p_331127_.discard("RecipesUsed");
        p_331127_.discard("saved_recipe");
        p_331127_.discard("saved_recipe_display");
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.tofucraft.tf_crafting_table.name");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int p_39954_, Inventory p_39955_, Player p_39956_) {
        return new TFCraftingTableMenu(p_39954_, p_39955_, this, this.dataAccess);
    }

    public void fillStackedContents(StackedItemContents stackedItemContents) {
        for (ItemStack itemstack : this.inventory) {
            stackedItemContents.accountSimpleStack(itemstack);
        }
    }

    @Override
    @javax.annotation.Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider p_323910_) {
        return this.saveCustomOnly(p_323910_);
    }

    @Override
    public void onDataPacket(Connection net, ValueInput valueInput) {
        super.onDataPacket(net, valueInput);
        this.loadAdditional(valueInput);
    }

    @Override
    public void inventoryChanged() {
        super.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }
}

