/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.client.model;

import baguchi.bagus_lib.client.layer.IArmor;
import baguchi.tofucraft.client.animation.definitions.TofunianAnimation;
import baguchi.tofucraft.client.render.state.AbstractTofunianRenderState;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;

public class AbstractTofunianModel<T extends AbstractTofunianRenderState>
extends EntityModel<T>
implements ArmedModel,
HeadedModel,
IArmor {
    public final ModelPart head;
    public final ModelPart hat;
    public final ModelPart body;
    public final ModelPart leftLeg;
    public final ModelPart rightLeg;
    public final ModelPart rightArm;
    public final ModelPart leftArm;
    public final ModelPart roots;
    private final KeyframeAnimation babyAnimation;

    public AbstractTofunianModel(ModelPart p_170688_) {
        super(p_170688_);
        this.roots = p_170688_.getChild("roots");
        this.head = this.roots.getChild("head");
        this.hat = this.head.getChild("hat");
        this.body = this.roots.getChild("body");
        this.leftLeg = this.roots.getChild("left_leg");
        this.rightLeg = this.roots.getChild("right_leg");
        this.leftArm = this.roots.getChild("left_arm");
        this.rightArm = this.roots.getChild("right_arm");
        this.babyAnimation = TofunianAnimation.BABY.bake(p_170688_);
    }

    public void setupAnim(T entity) {
        boolean flag;
        super.setupAnim(entity);
        this.head.yRot = ((AbstractTofunianRenderState)((Object)entity)).yRot * ((float)Math.PI / 180);
        this.head.xRot = ((AbstractTofunianRenderState)((Object)entity)).xRot * ((float)Math.PI / 180);
        boolean bl = flag = ((AbstractTofunianRenderState)((Object)entity)).unhappyCounter > 0;
        if (flag) {
            this.head.zRot = 0.3f * Mth.sin((float)(0.45f * ((AbstractTofunianRenderState)((Object)entity)).ageInTicks));
            this.head.xRot = 0.4f;
        } else {
            this.head.zRot = 0.0f;
        }
        if (((AbstractTofunianRenderState)((Object)entity)).isPassenger) {
            this.rightArm.xRot = -0.62831855f;
            this.leftArm.xRot = -0.62831855f;
            this.rightLeg.xRot = -1.4137167f;
            this.leftLeg.xRot = -1.4137167f;
        } else {
            this.rightArm.xRot = Mth.cos((float)(((AbstractTofunianRenderState)((Object)entity)).walkAnimationPos * 0.6662f + (float)Math.PI)) * 2.0f * ((AbstractTofunianRenderState)((Object)entity)).walkAnimationSpeed * 0.5f;
            this.leftArm.xRot = Mth.cos((float)(((AbstractTofunianRenderState)((Object)entity)).walkAnimationPos * 0.6662f)) * 2.0f * ((AbstractTofunianRenderState)((Object)entity)).walkAnimationSpeed * 0.5f;
            this.rightLeg.xRot = Mth.cos((float)(((AbstractTofunianRenderState)((Object)entity)).walkAnimationPos * 0.6662f)) * 1.4f * ((AbstractTofunianRenderState)((Object)entity)).walkAnimationSpeed * 0.5f;
            this.leftLeg.xRot = Mth.cos((float)(((AbstractTofunianRenderState)((Object)entity)).walkAnimationPos * 0.6662f + (float)Math.PI)) * 1.4f * ((AbstractTofunianRenderState)((Object)entity)).walkAnimationSpeed * 0.5f;
        }
        if (((AbstractTofunianRenderState)((Object)entity)).attackTime > 0.0f) {
            if (((AbstractTofunianRenderState)((Object)entity)).mainArm == HumanoidArm.RIGHT) {
                this.rightArm.xRot = ((AbstractTofunianRenderState)((Object)entity)).attackTime * -0.75f;
                this.rightArm.zRot = ((AbstractTofunianRenderState)((Object)entity)).attackTime * -0.5f;
            } else {
                this.rightArm.xRot = ((AbstractTofunianRenderState)((Object)entity)).attackTime * -0.75f;
                this.rightArm.zRot = ((AbstractTofunianRenderState)((Object)entity)).attackTime * 0.5f;
            }
        }
        float f6 = 12.0f;
        if (((AbstractTofunianRenderState)((Object)entity)).isBaby) {
            this.babyAnimation.applyStatic();
            this.rightArm.visible = false;
            this.leftArm.visible = false;
            this.body.visible = false;
        } else {
            this.rightArm.visible = true;
            this.leftArm.visible = true;
            this.body.visible = true;
        }
    }

    public ModelPart getArm(HumanoidArm p_102923_) {
        return p_102923_ == HumanoidArm.LEFT ? this.leftArm : this.rightArm;
    }

    public ModelPart getHead() {
        return this.head;
    }

    public void translateToHead(PoseStack poseStack) {
        this.roots.translateAndRotate(poseStack);
        this.head.translateAndRotate(poseStack);
    }

    public void translateToHead(ModelPart modelPart, PoseStack poseStack) {
        this.roots.translateAndRotate(poseStack);
        modelPart.translateAndRotate(poseStack);
    }

    public void translateToChest(ModelPart modelPart, PoseStack poseStack) {
        this.roots.translateAndRotate(poseStack);
        modelPart.translateAndRotate(poseStack);
        poseStack.scale(0.75f, 0.75f, 0.75f);
    }

    public void translateToLeg(ModelPart modelPart, PoseStack poseStack) {
        this.roots.translateAndRotate(poseStack);
        modelPart.translateAndRotate(poseStack);
        poseStack.scale(0.5f, 0.5f, 0.5f);
    }

    public void translateToChestPat(ModelPart modelPart, PoseStack poseStack) {
        this.roots.translateAndRotate(poseStack);
        modelPart.translateAndRotate(poseStack);
        poseStack.scale(0.65f, 0.65f, 0.65f);
    }

    public Iterable<ModelPart> rightHandArmors() {
        return ImmutableList.of((Object)this.rightArm);
    }

    public Iterable<ModelPart> leftHandArmors() {
        return ImmutableList.of((Object)this.leftArm);
    }

    public Iterable<ModelPart> rightLegPartArmors() {
        return ImmutableList.of((Object)this.rightLeg);
    }

    public Iterable<ModelPart> leftLegPartArmors() {
        return ImmutableList.of((Object)this.leftLeg);
    }

    public Iterable<ModelPart> bodyPartArmors() {
        return ImmutableList.of((Object)this.body);
    }

    public Iterable<ModelPart> headPartArmors() {
        return ImmutableList.of((Object)this.head);
    }

    public void translateToHand(EntityRenderState entityRenderState, HumanoidArm humanoidArm, PoseStack poseStack) {
        this.roots.translateAndRotate(poseStack);
        this.getArm(humanoidArm).translateAndRotate(poseStack);
        poseStack.translate(0.0f, -0.125f, 0.0f);
        poseStack.scale(0.85f, 0.85f, 0.85f);
    }
}

