/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.client.render.entity;

import baguchi.tofucraft.client.TofuModelLayers;
import baguchi.tofucraft.client.model.TofuGandlemModel;
import baguchi.tofucraft.client.render.layer.TofuGandlemChargedLayer;
import baguchi.tofucraft.client.render.layer.TofuGandlemEmissiveLayer;
import baguchi.tofucraft.client.render.state.TofuGandlemRenderState;
import baguchi.tofucraft.entity.TofuGandlem;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class TofuGandlemRender
extends MobRenderer<TofuGandlem, TofuGandlemRenderState, TofuGandlemModel<TofuGandlemRenderState>> {
    private static final ResourceLocation LOCATION = ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"textures/entity/tofu_gandlem/tofu_gandlem.png");
    private static final ResourceLocation SHOOTING_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"textures/entity/tofu_gandlem/tofu_gandlem_shooting.png");
    private static final ResourceLocation CHARGE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"textures/entity/tofu_gandlem/tofu_gandlem_charge.png");

    public TofuGandlemRender(EntityRendererProvider.Context p_173956_) {
        super(p_173956_, new TofuGandlemModel(p_173956_.bakeLayer(TofuModelLayers.TOFU_GANDLEM)), 0.5f);
        this.addLayer(new TofuGandlemEmissiveLayer<TofuGandlemRenderState, TofuGandlemModel>((RenderLayerParent<TofuGandlemRenderState, TofuGandlemModel>)this, LOCATION, (p_234809_, p_234810_, p_234811_) -> p_234809_.deathTime <= 0.0f && !p_234809_.sleep ? Mth.clamp((float)(p_234809_.health / p_234809_.maxHealth + 0.4f), (float)0.4f, (float)1.0f) : 0.0f, TofuGandlemModel::getCoreModelParts));
        this.addLayer(new TofuGandlemChargedLayer<TofuGandlemRenderState, TofuGandlemModel>((RenderLayerParent<TofuGandlemRenderState, TofuGandlemModel>)this, CHARGE_LOCATION, (p_234809_, p_234810_, p_234811_) -> p_234809_.health > 0.0f ? 1.0f : 0.0f, TofuGandlemModel::getCoreModelParts));
    }

    public TofuGandlemRenderState createRenderState() {
        return new TofuGandlemRenderState();
    }

    public void extractRenderState(TofuGandlem p_362733_, TofuGandlemRenderState p_360515_, float p_361157_) {
        super.extractRenderState((LivingEntity)p_362733_, (LivingEntityRenderState)p_360515_, p_361157_);
        p_360515_.idleAnimationState.copyFrom(p_362733_.idleAnimationState);
        p_360515_.attackAnimationState.copyFrom(p_362733_.attackAnimationState);
        p_360515_.preShootAnimationState.copyFrom(p_362733_.preShootAnimationState);
        p_360515_.stopShootAnimationState.copyFrom(p_362733_.stopShootAnimationState);
        p_360515_.shootAnimationState.copyFrom(p_362733_.shootAnimationState);
        p_360515_.shootingAnimationState.copyFrom(p_362733_.shootingAnimationState);
        p_360515_.rushAnimationState.copyFrom(p_362733_.rushAnimationState);
        p_360515_.deathAnimationState.copyFrom(p_362733_.deathAnimationState);
        p_360515_.chargeAnimationState.copyFrom(p_362733_.chargeAnimationState);
        p_360515_.chargeStopAnimationState.copyFrom(p_362733_.chargeStopAnimationState);
        p_360515_.chargeFailAnimationState.copyFrom(p_362733_.chargeFailAnimationState);
        p_360515_.chargeHealth = p_362733_.getChargeHealth();
        p_360515_.charge = p_362733_.isCharging();
        p_360515_.shoot = p_362733_.getAction() == TofuGandlem.Actions.PRE_SHOOT || p_362733_.getAction() == TofuGandlem.Actions.SHOOT;
        p_360515_.sleep = p_362733_.isSleepSelf();
        p_360515_.health = p_362733_.getHealth();
        p_360515_.maxHealth = p_362733_.getMaxHealth();
        p_360515_.fullCharge = p_362733_.isFullCharge();
    }

    protected float getFlipDegrees() {
        return 0.0f;
    }

    public ResourceLocation getTextureLocation(TofuGandlemRenderState p_114029_) {
        return p_114029_.charge || p_114029_.shoot ? SHOOTING_LOCATION : LOCATION;
    }
}

