/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.entity;

import baguchi.tofucraft.entity.ShuDofuSpider;
import baguchi.tofucraft.entity.projectile.FukumameEntity;
import baguchi.tofucraft.registry.TofuAdvancements;
import baguchi.tofucraft.registry.TofuEntityTypes;
import baguchi.tofucraft.registry.TofuItems;
import baguchi.tofucraft.registry.TofuSounds;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.event.EventHooks;

public class TofuSpider
extends Spider
implements RangedAttackMob {
    private static final EntityDataAccessor<Boolean> DATA_CONVERTING_ID = SynchedEntityData.defineId(TofuSpider.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private int conversionTime;

    public TofuSpider(EntityType<? extends TofuSpider> p_33786_, Level p_33787_) {
        super(p_33786_, p_33787_);
        this.xpReward = 4;
    }

    protected InteractionResult mobInteract(Player p_21472_, InteractionHand p_21473_) {
        ItemStack stack = p_21472_.getItemInHand(p_21473_);
        if (stack.is(TofuItems.SOYMILK_OMINOUS_BOTTLE) && !this.isConverting() && this.hasEffect(MobEffects.DARKNESS)) {
            this.startConverting(300);
            if (!p_21472_.getAbilities().instabuild) {
                stack.shrink(1);
            }
            if (!p_21472_.addItem(new ItemStack((ItemLike)Items.GLASS_BOTTLE))) {
                p_21472_.drop(new ItemStack((ItemLike)Items.GLASS_BOTTLE), false);
            }
            this.playSound(SoundEvents.ZOMBIE_VILLAGER_CURE, 3.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(p_21472_, p_21473_);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_CONVERTING_ID, (Object)false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 18.0).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.FOLLOW_RANGE, 18.0);
    }

    protected SoundEvent getAmbientSound() {
        return TofuSounds.TOFUSPIDER_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource p_33814_) {
        return TofuSounds.TOFUSPIDER_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return TofuSounds.TOFUSPIDER_DEATH.get();
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(2, (Goal)new TofuSpiderAttackGoal(this));
    }

    public void addAdditionalSaveData(ValueOutput p_34397_) {
        super.addAdditionalSaveData(p_34397_);
        p_34397_.putInt("ConversionTime", this.isConverting() ? this.conversionTime : -1);
    }

    public void readAdditionalSaveData(ValueInput p_34387_) {
        super.readAdditionalSaveData(p_34387_);
        if (p_34387_.getIntOr("ConversionTime", -1) > -1) {
            this.startConverting(p_34387_.getIntOr("ConversionTime", -1));
        }
    }

    public void tick() {
        if (!this.level().isClientSide() && this.isAlive() && this.isConverting()) {
            --this.conversionTime;
            if (this.conversionTime <= 0 && EventHooks.canLivingConvert((LivingEntity)this, TofuEntityTypes.SHUDOFUSPIDER.get(), timer -> {
                this.conversionTime = timer;
            })) {
                this.finishConversion((ServerLevel)this.level());
                if (EventHooks.canEntityGrief((ServerLevel)((ServerLevel)this.level()), (Entity)this)) {
                    int j1 = Mth.floor((double)this.getY());
                    int i2 = Mth.floor((double)this.getX());
                    int j2 = Mth.floor((double)this.getZ());
                    boolean flag = false;
                    for (int j = -1; j <= 1; ++j) {
                        for (int k2 = -1; k2 <= 1; ++k2) {
                            for (int k = 0; k <= 3; ++k) {
                                int l2 = i2 + j;
                                int l = j1 + k;
                                int i1 = j2 + k2;
                                BlockPos blockpos = new BlockPos(l2, l, i1);
                                BlockState blockstate = this.level().getBlockState(blockpos);
                                if (!WitherBoss.canDestroy((BlockState)blockstate) || !EventHooks.onEntityDestroyBlock((LivingEntity)this, (BlockPos)blockpos, (BlockState)blockstate)) continue;
                                flag = this.level().destroyBlock(blockpos, true, (Entity)this) || flag;
                            }
                        }
                    }
                    if (flag) {
                        this.level().levelEvent((Entity)((Player)null), 1022, this.blockPosition(), 0);
                    }
                }
            }
        }
        super.tick();
    }

    private void finishConversion(ServerLevel p_34399_) {
        ShuDofuSpider shudofuSpider = (ShuDofuSpider)this.convertTo(TofuEntityTypes.SHUDOFUSPIDER.get(), ConversionParams.single((Mob)this, (boolean)false, (boolean)true), p_371719_ -> {});
        shudofuSpider.finalizeSpawn((ServerLevelAccessor)p_34399_, p_34399_.getCurrentDifficultyAt(shudofuSpider.blockPosition()), EntitySpawnReason.CONVERSION, null);
        List players = p_34399_.getNearbyPlayers(TargetingConditions.forNonCombat().ignoreInvisibilityTesting().ignoreLineOfSight(), (LivingEntity)this, this.getBoundingBox().inflate(60.0));
        for (Player player : players) {
            if (!(player instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            TofuAdvancements.NIGHTMARES_ECHO.get().trigger(serverPlayer);
        }
        shudofuSpider.addEffect(new MobEffectInstance(MobEffects.NAUSEA, 200, 0));
        if (!this.isSilent()) {
            this.playSound(SoundEvents.WITHER_SPAWN, 4.0f, 1.0f);
        }
        EventHooks.onLivingConvert((LivingEntity)this, (LivingEntity)shudofuSpider);
    }

    public boolean removeWhenFarAway(double p_34414_) {
        return !this.isConverting();
    }

    public boolean isConverting() {
        return (Boolean)this.getEntityData().get(DATA_CONVERTING_ID);
    }

    public void startConverting(int p_34385_) {
        this.getEntityData().set(DATA_CONVERTING_ID, (Object)true);
        this.conversionTime = p_34385_;
        this.level().broadcastEntityEvent((Entity)this, (byte)16);
    }

    protected float getStandingEyeHeight(Pose p_33799_, EntityDimensions p_33800_) {
        return 0.35f;
    }

    protected boolean considersEntityAsAlly(Entity p_360600_) {
        if (super.considersEntityAsAlly(p_360600_)) {
            return true;
        }
        if (p_360600_.getType() == TofuEntityTypes.SHUDOFUSPIDER) {
            return this.getTeam() == null && p_360600_.getTeam() == null;
        }
        return false;
    }

    protected AABB getAttackBoundingBox() {
        return super.getAttackBoundingBox().deflate((double)0.025f, 0.0, (double)0.025f);
    }

    public void performRangedAttack(LivingEntity p_29912_, float p_29913_) {
        this.playSound(SoundEvents.LLAMA_SPIT, 1.0f, 1.0f);
        for (int i = 0; i < 3; ++i) {
            FukumameEntity fukumame = new FukumameEntity(this.level(), (LivingEntity)this);
            double d1 = p_29912_.getX() - this.getX();
            double d2 = p_29912_.getEyeY() - this.getEyeY();
            double d3 = p_29912_.getZ() - this.getZ();
            float f = Mth.sqrt((float)((float)(d1 * d1 + d3 * d3))) * 0.2f;
            fukumame.damage = 1.0f;
            fukumame.shoot(d1, d2 + (double)f, d3, 1.0f, 2.0f + p_29913_);
            this.level().addFreshEntity((Entity)fukumame);
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, EntitySpawnReason spawnType, @Nullable SpawnGroupData spawnGroupData) {
        return spawnGroupData;
    }

    static class TofuSpiderAttackGoal
    extends Goal {
        private final TofuSpider spider;
        private int attackStep;
        private int attackTime;
        private int lastSeen;

        public TofuSpiderAttackGoal(TofuSpider p_32247_) {
            this.spider = p_32247_;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            LivingEntity livingentity = this.spider.getTarget();
            return livingentity != null && livingentity.isAlive() && this.spider.canAttack(livingentity);
        }

        public void start() {
            this.attackStep = 0;
        }

        public void stop() {
            this.lastSeen = 0;
        }

        public void tick() {
            --this.attackTime;
            LivingEntity livingentity = this.spider.getTarget();
            if (livingentity != null) {
                boolean flag = this.spider.getSensing().hasLineOfSight((Entity)livingentity);
                this.lastSeen = flag ? 0 : ++this.lastSeen;
                double d0 = this.spider.distanceToSqr((Entity)livingentity);
                if (d0 < 32.0) {
                    if (!flag) {
                        return;
                    }
                    this.attackStep = 0;
                    if (d0 < 4.0 + (double)this.spider.getBbWidth() && this.attackTime <= 0) {
                        this.attackTime = 20;
                        Level level = this.spider.level();
                        if (level instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level;
                            this.spider.doHurtTarget(serverLevel, (Entity)livingentity);
                        }
                    }
                    this.spider.getLookControl().setLookAt((Entity)livingentity, 10.0f, 10.0f);
                    this.spider.getNavigation().moveTo(livingentity.getX(), livingentity.getY(), livingentity.getZ(), 1.0);
                } else if (d0 < this.getFollowDistance() * this.getFollowDistance() && flag) {
                    if (this.attackTime <= 0) {
                        ++this.attackStep;
                        if (this.attackStep == 1) {
                            this.attackTime = 20;
                        } else if (this.attackStep <= 2) {
                            this.attackTime = 10;
                        } else {
                            this.attackTime = 30;
                            this.attackStep = 0;
                        }
                        if (this.attackStep > 1) {
                            this.spider.performRangedAttack(livingentity, this.attackTime);
                            this.spider.playSound(TofuSounds.TOFUSPIDER_SPIT.get(), 1.0f, (float)((double)0.9f + this.spider.random.nextDouble() * (double)0.2f));
                        }
                    }
                    this.spider.getLookControl().setLookAt((Entity)livingentity, 10.0f, 10.0f);
                    this.spider.getNavigation().stop();
                } else if (this.lastSeen < 5) {
                    this.spider.getNavigation().moveTo(livingentity.getX(), livingentity.getY(), livingentity.getZ(), 1.0);
                }
                super.tick();
            }
        }

        private double getFollowDistance() {
            return this.spider.getAttributeValue(Attributes.FOLLOW_RANGE);
        }
    }
}

