/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.entity.behaviors;

import baguchi.tofucraft.entity.FukumameThrower;
import baguchi.tofucraft.entity.projectile.NetherFukumameEntity;
import baguchi.tofucraft.registry.TofuEntityTypes;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ThrowFukumame<E extends FukumameThrower>
extends Behavior<E> {
    protected int ticks;

    public ThrowFukumame() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.REGISTERED));
    }

    protected boolean checkExtraStartConditions(ServerLevel p_22538_, E p_22539_) {
        return ((FukumameThrower)((Object)p_22539_)).getFukumameCount() > 0 && p_22539_.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).isPresent();
    }

    protected boolean canStillUse(ServerLevel p_22545_, E p_22546_, long p_22547_) {
        return ((FukumameThrower)((Object)p_22546_)).getFukumameCount() > 0 && p_22546_.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).isPresent();
    }

    protected void start(ServerLevel p_22540_, E p_22541_, long p_22542_) {
        super.start(p_22540_, p_22541_, p_22542_);
        ((FukumameThrower)((Object)p_22541_)).setCharge(true);
    }

    protected void stop(ServerLevel p_22548_, E p_22549_, long p_22550_) {
        super.stop(p_22548_, p_22549_, p_22550_);
        ((FukumameThrower)((Object)p_22549_)).setCharge(false);
    }

    protected void tick(ServerLevel p_22551_, E p_22552_, long p_22553_) {
        super.tick(p_22551_, p_22552_, p_22553_);
        Optional optional = p_22552_.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET);
        if (optional.isPresent()) {
            LivingEntity livingEntity = (LivingEntity)optional.get();
            if (p_22552_.hasLineOfSight((Entity)optional.get()) && p_22552_.distanceToSqr((Entity)optional.get()) < 64.0) {
                if (++this.ticks == 80) {
                    p_22552_.swing(InteractionHand.MAIN_HAND);
                    ((FukumameThrower)((Object)p_22552_)).setCharge(false);
                    ((FukumameThrower)((Object)p_22552_)).setFukumameCount(Math.max(((FukumameThrower)((Object)p_22552_)).getFukumameCount() - 1, 0));
                    Vec3 vec3 = livingEntity.getDeltaMovement();
                    double d0 = livingEntity.getX() + vec3.x - p_22552_.getX();
                    double d1 = livingEntity.getEyeY() - p_22552_.getEyeY() - (double)0.1f;
                    double d2 = livingEntity.getZ() + vec3.z - p_22552_.getZ();
                    double d3 = Math.sqrt(d0 * d0 + d2 * d2);
                    for (int i = 0; i < 4; ++i) {
                        NetherFukumameEntity entity = (NetherFukumameEntity)TofuEntityTypes.NETHER_FUKUMAME.get().create((Level)p_22551_, EntitySpawnReason.SPAWN_ITEM_USE);
                        entity.setXRot(entity.getXRot() - -20.0f);
                        entity.shoot(d0, d1 + d3 * 0.3, d2, 0.75f, 8.0f);
                        entity.setOwner((Entity)p_22552_);
                        entity.setPos(p_22552_.position().x(), p_22552_.getEyeY() - (double)0.1f, p_22552_.position().z());
                        p_22551_.addFreshEntity((Entity)entity);
                    }
                    p_22552_.playSound(SoundEvents.SNOWBALL_THROW);
                }
                if (this.ticks > 100) {
                    this.ticks = 0;
                    ((FukumameThrower)((Object)p_22552_)).setCharge(true);
                }
            } else {
                p_22552_.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget((Entity)optional.get(), 0.8f, 6));
            }
        } else {
            this.ticks = 0;
            ((FukumameThrower)((Object)p_22552_)).setCharge(true);
        }
    }
}

