/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.entity.goal;

import baguchi.tofucraft.entity.TofuCow;
import baguchi.tofucraft.entity.Tofunian;
import baguchi.tofucraft.registry.TofuItems;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;

public class MakeSoymilkGoal
extends Goal {
    private final Tofunian creature;
    private final double speedIn;
    private int cookTick;
    private int cooldown = -100;
    private boolean stop;
    private TofuCow cow;

    public MakeSoymilkGoal(Tofunian creature, double speedIn) {
        this.creature = creature;
        this.speedIn = speedIn;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.cooldown == -100) {
            this.cooldown = 400 + this.creature.getRandom().nextInt(400);
        }
        if (this.creature.getRole() == Tofunian.Roles.SOYWORKER && !this.creature.hasExcessFood() && this.creature.level().isBrightOutside()) {
            if (this.cooldown-- <= 0) {
                List list = this.creature.level().getEntities(EntityTypeTest.forClass(TofuCow.class), new AABB(this.creature.getX() - 16.0, this.creature.getY() - 16.0, this.creature.getZ() - 16.0, this.creature.getX() + 16.0, this.creature.getY() + 16.0, this.creature.getZ() + 16.0), p_147140_ -> p_147140_.isAlive());
                this.cooldown = 400 + this.creature.getRandom().nextInt(400);
                if (!list.isEmpty()) {
                    this.cow = (TofuCow)((Object)list.get(this.creature.getRandom().nextInt(list.size())));
                    return true;
                }
            }
        } else {
            return false;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.creature.getRole() == Tofunian.Roles.SOYWORKER && !this.creature.hasExcessFood() && this.creature.level().isBrightOutside() && this.cow != null && this.stop;
    }

    public void start() {
        super.start();
        this.cookTick = 0;
    }

    public void tick() {
        super.tick();
        if (this.cow != null && this.cow.isAlive()) {
            this.creature.getLookControl().setLookAt((Entity)this.cow, 30.0f, 30.0f);
            if (this.cookTick > 0) {
                --this.cookTick;
            }
            if (this.creature.distanceTo((Entity)this.cow) < 1.5f) {
                if (this.cookTick <= 0) {
                    this.creature.getInventory().addItem(new ItemStack((ItemLike)TofuItems.SOYMILK.get()));
                    this.creature.swing(InteractionHand.MAIN_HAND);
                    this.creature.playSound(SoundEvents.COW_MILK, 1.0f, 1.0f);
                    this.cookTick = 60;
                    this.stop = true;
                }
            } else {
                this.creature.getNavigation().moveTo((Entity)this.cow, this.speedIn);
            }
        }
    }

    public void stop() {
        super.stop();
        this.stop = false;
    }
}

