/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.entity.goal;

import baguchi.tofucraft.entity.Tofunian;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;

public class RestockGoal
extends MoveToBlockGoal {
    private final Tofunian creature;
    private boolean restockComplete;

    public RestockGoal(Tofunian creature, double speedIn, int length) {
        super((PathfinderMob)creature, speedIn, length);
        this.creature = creature;
    }

    public boolean canUse() {
        return this.creature.level().isBrightOutside() && this.creature.getRole() != Tofunian.Roles.TOFUNIAN && this.creature.canResetStock() && !this.creature.isBaby() && super.canUse();
    }

    public boolean canContinueToUse() {
        return super.canContinueToUse() && this.creature.level().isBrightOutside() && this.creature.canResetStock() && !this.creature.isBaby() && this.creature.getRole() != Tofunian.Roles.TOFUNIAN;
    }

    public void tick() {
        super.tick();
        if (this.isReachedTarget() && !this.restockComplete) {
            this.creature.restock();
            this.creature.swing(InteractionHand.MAIN_HAND);
            this.creature.playSound(SoundEvents.ITEM_PICKUP, 1.0f, 0.7f);
            this.restockComplete = true;
        }
    }

    protected boolean isValidTarget(LevelReader worldIn, BlockPos pos) {
        BlockState blockstate = worldIn.getBlockState(pos);
        return this.creature.getRole().is(blockstate);
    }

    protected boolean findNearestBlock() {
        if (this.creature.getTofunianJobBlock() != null && this.isValidTarget((LevelReader)this.creature.level(), this.creature.getTofunianJobBlock())) {
            this.blockPos = this.creature.getTofunianJobBlock();
            return true;
        }
        return false;
    }

    public void stop() {
        super.stop();
        this.restockComplete = false;
    }

    public double acceptedDistance() {
        return 2.0;
    }
}

