/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.entity.goal;

import baguchi.tofucraft.entity.AbstractTofunian;
import baguchi.tofucraft.entity.Tofunian;
import baguchi.tofucraft.entity.TravelerTofunian;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;

public class TofunianTradeWithPlayerGoal
extends Goal {
    private final AbstractTofunian mob;

    public TofunianTradeWithPlayerGoal(AbstractTofunian p_25958_) {
        this.mob = p_25958_;
        this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (!this.mob.isAlive()) {
            return false;
        }
        if (this.mob.isInWater()) {
            return false;
        }
        if (!this.mob.onGround()) {
            return false;
        }
        if (this.mob.hurtMarked) {
            return false;
        }
        Player player = this.mob.getTradingPlayer();
        if (player == null) {
            return false;
        }
        if (this.mob.distanceToSqr((Entity)player) > 16.0) {
            return false;
        }
        return player.containerMenu != null;
    }

    public void start() {
        AbstractTofunian tofunian;
        this.mob.getNavigation().stop();
        AbstractTofunian abstractTofunian = this.mob;
        if (abstractTofunian instanceof Tofunian) {
            tofunian = (Tofunian)abstractTofunian;
            tofunian.setAction(Tofunian.Actions.WAVE);
        }
        if ((abstractTofunian = this.mob) instanceof TravelerTofunian) {
            tofunian = (TravelerTofunian)abstractTofunian;
            this.mob.level().broadcastEntityEvent((Entity)this.mob, (byte)100);
        }
    }

    public void stop() {
        this.mob.setTradingPlayer(null);
    }
}

