/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.inventory;

import baguchi.tofucraft.inventory.slot.TFOvenResultSlot;
import baguchi.tofucraft.registry.TofuMenus;
import java.util.List;
import net.minecraft.recipebook.ServerPlaceRecipe;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipePropertySet;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;

public class TFOvenMenu
extends RecipeBookMenu {
    public static final int INGREDIENT_SLOT = 0;
    public static final int FUEL_SLOT = 1;
    public static final int RESULT_SLOT = 2;
    public static final int SLOT_COUNT = 3;
    public static final int DATA_COUNT = 4;
    private static final int INV_SLOT_START = 3;
    private static final int INV_SLOT_END = 30;
    private static final int USE_ROW_SLOT_START = 30;
    private static final int USE_ROW_SLOT_END = 39;
    final Container container;
    private final ContainerData data;
    protected final Level level;
    private final RecipeType<? extends AbstractCookingRecipe> recipeType = RecipeType.SMELTING;
    private final RecipePropertySet acceptedInputs;
    private final RecipeBookType recipeBookType = RecipeBookType.FURNACE;

    public TFOvenMenu(int p_38969_, Inventory p_38970_) {
        this(p_38969_, p_38970_, (Container)new SimpleContainer(2), (ContainerData)new SimpleContainerData(3));
    }

    public TFOvenMenu(int p_38963_, Inventory p_38964_, Container p_379971_, ContainerData p_379737_) {
        super(TofuMenus.TF_OVEN.get(), p_38963_);
        TFOvenMenu.checkContainerSize((Container)p_379971_, (int)2);
        TFOvenMenu.checkContainerDataCount((ContainerData)p_379737_, (int)3);
        this.container = p_379971_;
        this.data = p_379737_;
        this.level = p_38964_.player.level();
        this.acceptedInputs = this.level.recipeAccess().propertySet(RecipePropertySet.FURNACE_INPUT);
        this.addSlot(new Slot(p_379971_, 0, 39, 15));
        this.addSlot(new TFOvenResultSlot(p_38964_.player, p_379971_, 1, 109, 15));
        this.addStandardInventorySlots((Container)p_38964_, 7, 83);
        this.addDataSlots(p_379737_);
    }

    public void fillCraftSlotsStackedContents(StackedItemContents p_363436_) {
        if (this.container instanceof StackedContentsCompatible) {
            ((StackedContentsCompatible)this.container).fillStackedContents(p_363436_);
        }
    }

    public Slot getResultSlot() {
        return (Slot)this.slots.get(1);
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }

    public ItemStack quickMoveStack(Player p_38986_, int p_38987_) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(p_38987_);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (p_38987_ != 1 && p_38987_ != 0 ? (this.canSmelt(itemstack1) ? !this.moveItemStackTo(itemstack1, 0, 1, false) : (p_38987_ >= 2 && p_38987_ < 29 ? !this.moveItemStackTo(itemstack1, 29, 38, false) : p_38987_ >= 29 && p_38987_ < 38 && !this.moveItemStackTo(itemstack1, 2, 29, false))) : !this.moveItemStackTo(itemstack1, 2, 38, false)) {
                return ItemStack.EMPTY;
            }
            slot.onQuickCraft(itemstack1, itemstack);
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(p_38986_, itemstack1);
        }
        return itemstack;
    }

    public float getTFForce() {
        int i = this.data.get(1);
        int j = this.data.get(2);
        return j != 0 && i != 0 ? Mth.clamp((float)((float)i / (float)j), (float)0.0f, (float)1.0f) : 0.0f;
    }

    public float getProgress() {
        int i = 0;
        if (i == 0) {
            i = 200;
        }
        return Mth.clamp((float)((float)this.data.get(0) / (float)i), (float)0.0f, (float)1.0f);
    }

    protected boolean canSmelt(ItemStack stack) {
        return this.acceptedInputs.test(stack);
    }

    public RecipeBookType getRecipeBookType() {
        return this.recipeBookType;
    }

    public RecipeBookMenu.PostPlaceAction handlePlacement(boolean p_361547_, boolean p_363944_, RecipeHolder<?> p_360938_, final ServerLevel p_379475_, Inventory p_361954_) {
        final List<Slot> list = List.of(this.getSlot(0));
        return ServerPlaceRecipe.placeRecipe((ServerPlaceRecipe.CraftingMenuAccess)new ServerPlaceRecipe.CraftingMenuAccess<AbstractCookingRecipe>(){

            public void fillCraftSlotsStackedContents(StackedItemContents p_361824_) {
                TFOvenMenu.this.fillCraftSlotsStackedContents(p_361824_);
            }

            public void clearCraftingContent() {
                list.forEach(p_362814_ -> p_362814_.set(ItemStack.EMPTY));
            }

            public boolean recipeMatches(RecipeHolder<AbstractCookingRecipe> p_361040_) {
                return ((AbstractCookingRecipe)p_361040_.value()).matches(new SingleRecipeInput(TFOvenMenu.this.container.getItem(0)), (Level)p_379475_);
            }
        }, (int)1, (int)1, List.of(this.getSlot(0)), list, (Inventory)p_361954_, p_360938_, (boolean)p_361547_, (boolean)p_363944_);
    }
}

