/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.inventory;

import baguchi.tofucraft.registry.TofuMenus;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class TFStorageMenu
extends AbstractContainerMenu {
    private final Container container;
    private final ContainerData data;
    protected final Level level;

    public TFStorageMenu(int i, Inventory playerInventory) {
        this(i, playerInventory, (Container)new SimpleContainer(2), (ContainerData)new SimpleContainerData(4));
    }

    public TFStorageMenu(int id, Inventory playerInventoryIn, Container furnaceInventoryIn, ContainerData dataIn) {
        super(TofuMenus.TF_STORAGE.get(), id);
        this.container = furnaceInventoryIn;
        this.data = dataIn;
        this.level = playerInventoryIn.player.level();
        furnaceInventoryIn.startOpen((ContainerUser)playerInventoryIn.player);
        this.addSlot(new Slot(this.container, 0, 23, 26));
        this.addSlot(new Slot(this.container, 1, 23, 44));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventoryIn, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)playerInventoryIn, k, 8 + k * 18, 142));
        }
        this.addDataSlots(dataIn);
    }

    public boolean stillValid(Player p_75145_1_) {
        return this.container.stillValid(p_75145_1_);
    }

    public ItemStack quickMoveStack(Player p_82846_1_, int slotIndex) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            switch (slotIndex) {
                case 0: {
                    if (this.moveItemStackTo(itemstack1, 2, 38, true)) break;
                    return ItemStack.EMPTY;
                }
                case 1: {
                    if (this.moveItemStackTo(itemstack1, 2, 38, true)) break;
                    return ItemStack.EMPTY;
                }
                default: {
                    if (this.moveItemStackTo(itemstack1, 0, 2, false)) break;
                    return ItemStack.EMPTY;
                }
            }
            slot.onQuickCraft(itemstack1, itemstack);
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(p_82846_1_, itemstack1);
        }
        return itemstack;
    }

    public int getBurnProgress() {
        int i = this.data.get(0);
        int j = this.data.get(1);
        return j != 0 && i != 0 ? i * 24 / j : 0;
    }

    public int getTFEnergy() {
        int i = this.data.get(2);
        return i;
    }

    public int getTFMaxEnergy() {
        int i = this.data.get(3);
        return i;
    }
}

