/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.item;

import baguchi.tofucraft.entity.TofuSpider;
import baguchi.tofucraft.registry.TofuSounds;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BugleItem
extends Item {
    private static final TargetingConditions TARGETING = TargetingConditions.forNonCombat().range(32.0).ignoreInvisibilityTesting();

    public BugleItem(Item.Properties tab) {
        super(tab);
    }

    public boolean releaseUsing(ItemStack p_41412_, Level p_41413_, LivingEntity livingEntity, int p_41415_) {
        Player playerentity;
        int i = this.getUseDuration(p_41412_, livingEntity) - p_41415_;
        if (livingEntity instanceof Player) {
            playerentity = (Player)livingEntity;
            if (i >= 20) {
                playerentity.awardStat(Stats.ITEM_USED.get((Object)this));
                playerentity.getCooldowns().addCooldown(p_41412_, 80);
            }
        }
        if (i >= 20) {
            p_41413_.gameEvent((Entity)livingEntity, (Holder)GameEvent.INSTRUMENT_PLAY, livingEntity.position());
            if (livingEntity.getOffhandItem().is(Items.ECHO_SHARD)) {
                if (livingEntity instanceof Player) {
                    playerentity = (Player)livingEntity;
                    List entities = p_41413_.getEntitiesOfClass(TofuSpider.class, livingEntity.getBoundingBox().inflate(6.0), tofuSpider -> true);
                    if (!entities.isEmpty()) {
                        for (TofuSpider spider : entities) {
                            if (!BugleItem.hasLineOfSight((LivingEntity)playerentity, (Entity)spider)) continue;
                            spider.addEffect(new MobEffectInstance(MobEffects.DARKNESS, 600));
                            p_41413_.levelEvent(3007, spider.blockPosition(), 0);
                        }
                        playerentity.getCooldowns().addCooldown(p_41412_, 1200);
                    }
                }
            } else {
                livingEntity.playSound(TofuSounds.TOFUBUGLE.get(), 3.0f, 1.0f);
            }
        }
        return false;
    }

    public static boolean hasLineOfSight(LivingEntity livingEntity, Entity p_147185_) {
        if (p_147185_.level() != livingEntity.level()) {
            return false;
        }
        Vec3 vec3 = new Vec3(livingEntity.getX(), livingEntity.getEyeY(), livingEntity.getZ());
        Vec3 vec31 = new Vec3(p_147185_.getX(), p_147185_.getEyeY(), p_147185_.getZ());
        if (vec31.distanceTo(vec3) > 128.0) {
            return false;
        }
        return livingEntity.level().clip(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)livingEntity)).getType() == HitResult.Type.MISS;
    }

    public InteractionResult use(Level p_41432_, Player p_41433_, InteractionHand p_41434_) {
        ItemStack itemstack = p_41433_.getItemInHand(p_41434_);
        p_41433_.startUsingItem(p_41434_);
        return InteractionResult.SUCCESS;
    }

    public int getUseDuration(ItemStack p_41454_, LivingEntity p_344979_) {
        return 72000;
    }

    public ItemUseAnimation getUseAnimation(ItemStack p_41452_) {
        return ItemUseAnimation.BOW;
    }
}

