/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.world.gen.feature;

import baguchi.tofucraft.registry.TofuBlocks;
import baguchi.tofucraft.registry.TofuTags;
import com.mojang.serialization.Codec;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class BigLeekFeature
extends Feature<NoneFeatureConfiguration> {
    public BigLeekFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> p_159749_) {
        if (!p_159749_.level().isEmptyBlock(p_159749_.origin())) {
            return false;
        }
        BlockState blockstate = p_159749_.level().getBlockState(p_159749_.origin().below());
        if (!blockstate.is(TofuTags.Blocks.TOFU_TERRAIN)) {
            return false;
        }
        if (p_159749_.random().nextInt(6) == 0) {
            this.setBigLeekBlock(p_159749_.level(), p_159749_.random(), p_159749_.origin());
        } else {
            this.setLeekBlock(p_159749_.level(), p_159749_.random(), p_159749_.origin());
        }
        return true;
    }

    private void setBigLeekBlock(WorldGenLevel level, RandomSource rand, BlockPos pos) {
        int height = 10 + rand.nextInt(8);
        for (int i = 0; i < height; ++i) {
            BlockPos blockpos1;
            Iterator iterator = BlockPos.betweenClosed((BlockPos)pos.offset(-1, 0, -1), (BlockPos)pos.offset(1, 0, 1)).iterator();
            while (iterator.hasNext() && (level.isEmptyBlock((blockpos1 = (BlockPos)iterator.next()).above(i)) || level.getBlockState(blockpos1.above(i)).is((Block)TofuBlocks.LEEK.get()) || level.getBlockState(blockpos1.above(i)).canBeReplaced())) {
                if ((double)(height - i) < (double)height / 2.5) {
                    level.setBlock(blockpos1.above(i), ((RotatedPillarBlock)TofuBlocks.LEEK_GREEN_STEM.get()).defaultBlockState(), 2);
                    continue;
                }
                level.setBlock(blockpos1.above(i), ((RotatedPillarBlock)TofuBlocks.LEEK_STEM.get()).defaultBlockState(), 2);
            }
        }
    }

    private void setLeekBlock(WorldGenLevel level, RandomSource rand, BlockPos pos) {
        int height = 5 + rand.nextInt(5);
        for (int i = 0; i < height && level.isEmptyBlock(pos.above(i)); ++i) {
            if ((double)(height - i) < (double)height / 2.5) {
                level.setBlock(pos.above(i), ((RotatedPillarBlock)TofuBlocks.LEEK_GREEN_STEM.get()).defaultBlockState(), 2);
                continue;
            }
            level.setBlock(pos.above(i), ((RotatedPillarBlock)TofuBlocks.LEEK_STEM.get()).defaultBlockState(), 2);
        }
    }
}

